/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.exception;

import aurora.service.ServiceContext;
import aurora.service.exception.IExceptionDescriptor;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.ocm.ISingleton;
import uncertain.proc.ProcedureRunner;

public class ExceptionHandler
implements ISingleton {
    IExceptionDescriptor mDesconfig;

    public ExceptionHandler(IExceptionDescriptor config) {
        this.mDesconfig = config;
    }

    public void onHandleException(ProcedureRunner runner) {
        Throwable thr = runner.getException();
        if (thr == null) {
            return;
        }
        ServiceContext context = (ServiceContext)DynamicObject.cast(runner.getContext(), ServiceContext.class);
        CompositeMap error = this.mDesconfig.process(context, thr);
        if (error != null) {
            context.setError(error);
        }
    }
}

