/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache.action;

import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.cache.action.AbstractCacheAction;
import uncertain.composite.CompositeMap;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class CacheRead
extends AbstractCacheAction {
    boolean writeCacheOnMissing = true;
    Procedure mProcedure;

    public CacheRead(INamedCacheFactory cacheFactory) {
        super(cacheFactory);
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        String key = this.getKey(context);
        String path = this.getDataPath();
        ICache cache = this.getCache();
        Object data = cache.getValue(key);
        if (data == null) {
            if (this.mProcedure != null) {
                runner.run(this.mProcedure);
                data = context.getObject(this.dataPath);
                if (data != null && this.writeCacheOnMissing) {
                    cache.setValue(key, data);
                }
            }
        } else {
            context.putObject(path, data, true);
        }
    }

    public void addProcedure(Procedure proc) {
        this.mProcedure = proc;
    }

    public Procedure getProcedure() {
        return this.mProcedure;
    }
}

