/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite;

import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;

public class CompositeLoaderSilentyWrapper {
    CompositeLoader loader;

    public CompositeLoaderSilentyWrapper(CompositeLoader loader) {
        this.loader = loader;
    }

    public CompositeMap loadFromString(String str) {
        try {
            return this.loader.loadFromString(str);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, "(" + str + ")", ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException("(" + str + ")", sex);
        }
    }

    public CompositeMap loadFromString(String str, String charsetName) {
        try {
            return this.loader.loadFromString(str, charsetName);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, "(" + str + ")", ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException("(" + str + ")", sex);
        }
    }

    public CompositeMap loadFromStream(InputStream stream) {
        try {
            return this.loader.loadFromStream(stream);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, "instance of " + stream.getClass(), ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException("instance of " + stream.getClass(), sex);
        }
    }

    public CompositeMap loadByURL(String url) {
        try {
            return this.loader.loadByURL(url);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, url, ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException(url, sex);
        }
    }

    public CompositeMap loadByFullFilePath_NC(String file_name) {
        try {
            return this.loader.loadByFullFilePath_NC(file_name);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, file_name, ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException(file_name, sex);
        }
    }

    public CompositeMap loadByFullFilePath(String file_name) {
        try {
            return this.loader.loadByFullFilePath(file_name);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, file_name, ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException(file_name, sex);
        }
    }

    public CompositeMap loadByFile(String file_name) {
        try {
            return this.loader.loadByFile(file_name);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, file_name, ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException(file_name, sex);
        }
    }

    public CompositeMap load(String resource_name) {
        try {
            return this.loader.load(resource_name);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, resource_name, ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException(resource_name, sex);
        }
    }

    public CompositeMap loadFromClassPath(String full_name) {
        try {
            return this.loader.loadFromClassPath(full_name);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, full_name, ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException(full_name, sex);
        }
    }

    public CompositeMap loadFromClassPath(String full_name, String file_ext) {
        try {
            return this.loader.loadFromClassPath(full_name, file_ext);
        }
        catch (IOException ex) {
            throw BuiltinExceptionFactory.createResourceLoadException(null, String.valueOf(full_name) + "[." + file_ext + "]", ex);
        }
        catch (SAXException sex) {
            throw BuiltinExceptionFactory.createXmlGrammarException(String.valueOf(full_name) + "[." + file_ext + "]", sex);
        }
    }
}

