/*
 * Decompiled with CFR 0.152.
 */
package uncertain.logging;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import uncertain.logging.ILogger;

public class LoggerList
implements ILogger {
    Set mLoggerSet = new HashSet();

    public LoggerList() {
    }

    public LoggerList(List loggers) {
        this.mLoggerSet.addAll(loggers);
    }

    public void addLogger(ILogger logger) {
        this.mLoggerSet.add(logger);
    }

    public void log(String message) {
        for (ILogger logger : this.mLoggerSet) {
            logger.log(message);
        }
    }

    public void log(String message, Object[] parameters) {
        for (ILogger logger : this.mLoggerSet) {
            logger.log(message, parameters);
        }
    }

    public void log(Level level, String message) {
        for (ILogger logger : this.mLoggerSet) {
            logger.log(level, message);
        }
    }

    public void log(Level level, String message, Object[] parameters) {
        for (ILogger logger : this.mLoggerSet) {
            logger.log(level, message, parameters);
        }
    }

    public void setLevel(Level level) {
        for (ILogger logger : this.mLoggerSet) {
            logger.setLevel(level);
        }
    }

    public void log(Level level, String message, Throwable thrown) {
        for (ILogger logger : this.mLoggerSet) {
            logger.log(level, message, thrown);
        }
    }

    public void warning(String message) {
        this.log(Level.WARNING, message);
    }

    public void severe(String message) {
        this.log(Level.SEVERE, message);
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void config(String message) {
        this.log(Level.CONFIG, message);
    }

    public int size() {
        return this.mLoggerSet.size();
    }

    public ILogger getFirst() {
        Iterator it = this.mLoggerSet.iterator();
        if (it.hasNext()) {
            return (ILogger)it.next();
        }
        return null;
    }
}

