/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.core.ConfigurationError;
import uncertain.mbean.IMBeanNameProvider;
import uncertain.mbean.IMBeanRegister;
import uncertain.mbean.IMBeanRegistrable;
import uncertain.ocm.ClassMapping;
import uncertain.ocm.ClassRegistryMBean;
import uncertain.ocm.FeatureAttach;
import uncertain.ocm.IClassLocator;
import uncertain.ocm.PackageMapping;
import uncertain.ocm.mbean.ClassMappingWrapper;
import uncertain.ocm.mbean.FeatureMapping;
import uncertain.ocm.mbean.PackageMappingWrapper;

public class ClassRegistry
implements IClassLocator,
IMBeanRegistrable,
ClassRegistryMBean {
    HashMap namespace_map = new HashMap();
    HashMap element_map = new HashMap();
    HashMap feature_map = new HashMap();

    public void register(String namespace, IClassLocator cl) {
        this.namespace_map.put(namespace, cl);
    }

    public void addPackageMapping(PackageMapping m) {
        String ns = m.getNameSpace();
        if (ns == null) {
            ns = m.getPackageName();
        }
        if (ns == null) {
            throw new ConfigurationError("must specify PackageName for package mapping");
        }
        this.register(ns, m);
    }

    public void addClassMapping(ClassMapping m) {
        this.element_map.put(m.getElementName(), m);
    }

    public void addClassMapping(String element_name, Class cls) {
        this.addClassMapping(element_name, cls.getName());
    }

    public void addClassMapping(String element_name, String class_name) {
        ClassMapping m = new ClassMapping();
        m.setElementName(element_name);
        m.setClassName(class_name);
        this.addClassMapping(m);
    }

    public PackageMapping registerPackage(String namespace, String package_name) {
        PackageMapping p = new PackageMapping(namespace, package_name);
        this.register(namespace, p);
        return p;
    }

    public PackageMapping registerPackage(String package_name) {
        return this.registerPackage(package_name, package_name);
    }

    public ClassMapping registerClass(String namespace, String element_name, String package_name, String class_name) {
        PackageMapping pm = (PackageMapping)this.namespace_map.get(namespace);
        if (pm == null) {
            pm = this.registerPackage(namespace, package_name);
        }
        ClassMapping m = new ClassMapping();
        m.setElementName(element_name);
        m.setClassName(class_name);
        pm.addClassMapping(m);
        return m;
    }

    public ClassMapping registerClass(String element_name, String package_name, String class_name) {
        ClassMapping m = new ClassMapping();
        m.setElementName(element_name);
        m.setClassName(class_name);
        m.setPackageName(package_name);
        this.addClassMapping(m);
        return m;
    }

    public IClassLocator getClassLocator(String namespace) {
        IClassLocator cl = (IClassLocator)this.namespace_map.get(namespace);
        return cl;
    }

    public String getClassName(CompositeMap config) {
        ClassMapping cm;
        String element_name = config.getName();
        if (element_name != null && (cm = (ClassMapping)this.element_map.get(element_name)) != null) {
            return cm.getClassName(config);
        }
        IClassLocator cl = this.getClassLocator(config.getNamespaceURI());
        if (cl != null) {
            return cl.getClassName(config);
        }
        return null;
    }

    void addMap(Map one, Map two) {
        for (Map.Entry entry : two.entrySet()) {
            if (one.containsKey(entry.getKey())) continue;
            one.put(entry.getKey(), entry.getValue());
        }
    }

    public void addAll(ClassRegistry another) {
        if (this == another) {
            return;
        }
        this.addAll(another, true);
    }

    public void addAll(ClassRegistry another, boolean override) {
        if (override) {
            this.element_map.putAll(another.element_map);
            this.namespace_map.putAll(another.namespace_map);
            this.feature_map.putAll(another.feature_map);
        } else {
            this.addMap(this.element_map, another.element_map);
            this.addMap(this.namespace_map, another.namespace_map);
            this.addMap(this.feature_map, another.feature_map);
        }
    }

    public void attachFeature(QualifiedName qname, Class feature_class) {
        LinkedList<Class> fList = (LinkedList<Class>)this.feature_map.get(qname);
        if (fList == null) {
            fList = new LinkedList<Class>();
            this.feature_map.put(qname, fList);
        }
        fList.add(feature_class);
    }

    public void attachFeature(String namespace, String element_name, Class feature_class) {
        this.attachFeature(new QualifiedName(namespace, element_name), feature_class);
    }

    public List getFeatures(QualifiedName eid) {
        List fList = (List)this.feature_map.get(eid);
        return fList;
    }

    public List getFeatures(String namespace, String element_name) {
        QualifiedName eid = new QualifiedName(namespace, element_name);
        return this.getFeatures(eid);
    }

    public List getFeatures(CompositeMap config) {
        return this.getFeatures(config.getQName());
    }

    public Map getFeatureMap() {
        return this.feature_map;
    }

    public void addFeatureAttach(FeatureAttach f) throws ClassNotFoundException {
        Class<?> fClass = Class.forName(f.getFeatureClass());
        this.attachFeature(f.getNameSpace(), f.getElementName(), fClass);
    }

    public PackageMapping[] getPackageMappings() {
        Object[] arrays = this.namespace_map.values().toArray();
        PackageMapping[] pa = new PackageMapping[arrays.length];
        System.arraycopy(arrays, 0, pa, 0, arrays.length);
        return pa;
    }

    public int getPackageMappingCount() {
        return this.namespace_map.size();
    }

    public int getClassMappingCount() {
        return this.element_map.size();
    }

    public int getFeatureAttachCount() {
        return this.feature_map.size();
    }

    public ClassMapping[] getClassMappings() {
        Object[] arrays = this.element_map.values().toArray();
        ClassMapping[] ca = new ClassMapping[arrays.length];
        System.arraycopy(arrays, 0, ca, 0, arrays.length);
        return ca;
    }

    public void registerMBean(IMBeanRegister register, IMBeanNameProvider name_provider) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String reg_name = name_provider.getMBeanName("BuiltinInstances", "instanceType=ClassRegistry");
        register.register(reg_name, this);
        PackageMapping[] pms = this.getPackageMappings();
        int i = 0;
        while (i < pms.length) {
            String n = name_provider.getMBeanName("BuiltinInstances", "instanceType=ClassRegistry,Array=PackageMappings,packageName=" + pms[i].getPackageName());
            register.register(n, new PackageMappingWrapper(pms[i]));
            ++i;
        }
        ClassMapping[] cms = this.getClassMappings();
        int i2 = 0;
        while (i2 < cms.length) {
            String n = name_provider.getMBeanName("BuiltinInstances", "instanceType=ClassRegistry,Array=ClassMappings,className=" + cms[i2].toString());
            register.register(n, new ClassMappingWrapper(cms[i2]));
            ++i2;
        }
        HashSet<String> local_name_set = new HashSet<String>();
        Iterator it = this.feature_map.entrySet().iterator();
        int id = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            QualifiedName qname = (QualifiedName)entry.getKey();
            List lst = (List)entry.getValue();
            FeatureMapping fm = new FeatureMapping(qname, lst);
            String local_name = qname.getLocalName();
            if (local_name_set.contains(local_name)) {
                local_name = String.valueOf(local_name) + "." + id;
            } else {
                local_name_set.add(local_name);
            }
            String n = name_provider.getMBeanName("BuiltinInstances", "instanceType=ClassRegistry,Array=FeatureAttaches,elementName=" + local_name);
            register.register(n, fm);
            ++id;
        }
        local_name_set.clear();
    }
}

