/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class Invoke
extends AbstractEntry {
    String mProcedure;
    boolean newContext = false;
    IProcedureManager mProcedureManager;

    public Invoke(IProcedureManager procedureManager) {
        this.mProcedureManager = procedureManager;
    }

    public void run(ProcedureRunner runner) throws Exception {
        if (this.mProcedure == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "procedure");
        }
        String proc_name = TextParser.parse(this.mProcedure, runner.getContext());
        Procedure proc = this.mProcedureManager.loadProcedure(proc_name);
        if (proc == null) {
            throw BuiltinExceptionFactory.createResourceLoadException(this, proc_name, null);
        }
        if (!this.newContext) {
            runner.call(proc);
            runner.checkAndThrow();
        } else {
            CompositeMap context = new CompositeMap("context");
            ProcedureRunner sub_runner = runner.spawn(proc);
            sub_runner.setContext(context);
            sub_runner.run();
            context.clear();
            sub_runner.checkAndThrow();
        }
    }

    public String getProcedure() {
        return this.mProcedure;
    }

    public void setProcedure(String procedure) {
        this.mProcedure = procedure;
    }

    public boolean getNewContext() {
        return this.newContext;
    }

    public void setNewContext(boolean newContext) {
        this.newContext = newContext;
    }
}

