/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.ocm.OCManager;
import uncertain.schema.Attribute;
import uncertain.schema.Category;
import uncertain.schema.ComplexType;
import uncertain.schema.Editor;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;
import uncertain.schema.IType;
import uncertain.schema.NamedObjectManager;
import uncertain.schema.Namespace;
import uncertain.schema.Schema;
import uncertain.schema.SchemaConstant;
import uncertain.schema.SimpleType;
import uncertain.schema.Wizard;

public class SchemaManager
implements ISchemaManager {
    public static final String DEFAULT_EXTENSION = "sxsd";
    static SchemaManager DEFAULT_INSTANCE = new SchemaManager();
    static Schema SCHEMA_FOR_SCHEMA;
    SchemaManager parent;
    CompositeLoader mCompositeLoader;
    NamedObjectManager mNamedObjectManager;
    OCManager mOcManager;

    static {
        try {
            SchemaManager.loadBuiltInSchema();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void loadBuiltInSchema() throws IOException, SAXException {
        String pkg_name = SchemaManager.class.getPackage().getName();
        String schema_name = String.valueOf(pkg_name) + ".SchemaForSchema";
        SCHEMA_FOR_SCHEMA = DEFAULT_INSTANCE.loadSchemaFromClassPath(schema_name);
    }

    public static SchemaManager getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Schema getSchemaForSchema() {
        return SCHEMA_FOR_SCHEMA;
    }

    private void _init() {
        this.mCompositeLoader = CompositeLoader.createInstanceForOCM(DEFAULT_EXTENSION);
        this.mCompositeLoader.setSaveNamespaceMapping(true);
        this.mNamedObjectManager = new NamedObjectManager();
    }

    public SchemaManager() {
        this._init();
        this.mOcManager = OCManager.getInstance();
        this.initOCManager();
    }

    public SchemaManager(OCManager oc_manager) {
        this._init();
        this.mOcManager = oc_manager;
        this.initOCManager();
    }

    private void initOCManager() {
        this.mOcManager.getClassRegistry().addPackageMapping(SchemaConstant.SCHEMA_NS_PACKAGE_MAPPING);
    }

    public Attribute getAttribute(QualifiedName qname) {
        Attribute attrbute = this.mNamedObjectManager.getAttribute(qname);
        if (attrbute == null && this.parent != null) {
            attrbute = this.parent.getAttribute(qname);
        }
        return attrbute;
    }

    public Element getElement(QualifiedName qname) {
        Element element = this.mNamedObjectManager.getElement(qname);
        if (element == null && this.parent != null) {
            element = this.parent.getElement(qname);
        }
        return element;
    }

    public ComplexType getComplexType(QualifiedName qname) {
        ComplexType complexType = this.mNamedObjectManager.getComplexType(qname);
        if (complexType == null && this.parent != null) {
            complexType = this.parent.getComplexType(qname);
        }
        return complexType;
    }

    public SimpleType getSimpleType(QualifiedName qname) {
        SimpleType simpleType = this.mNamedObjectManager.getSimpleType(qname);
        if (simpleType == null && this.parent != null) {
            simpleType = this.parent.getSimpleType(qname);
        }
        return simpleType;
    }

    public IType getType(QualifiedName qname) {
        IType type = this.mNamedObjectManager.getType(qname);
        if (type == null && this.parent != null) {
            type = this.parent.getType(qname);
        }
        return type;
    }

    public Category getCategory(QualifiedName qname) {
        Category category = this.mNamedObjectManager.getCategory(qname);
        if (category == null && this.parent != null) {
            category = this.parent.getCategory(qname);
        }
        return category;
    }

    public Editor getEditor(QualifiedName qname) {
        Editor editor = this.mNamedObjectManager.getEditor(qname);
        if (editor == null && this.parent != null) {
            editor = this.parent.getEditor(qname);
        }
        return editor;
    }

    public Wizard getWizard(QualifiedName qname) {
        Wizard wizard = this.mNamedObjectManager.getWizard(qname);
        if (wizard == null && this.parent != null) {
            wizard = this.parent.getWizard(qname);
        }
        return wizard;
    }

    Namespace[] getNameSpaces(CompositeMap map) {
        Map ns_map = map.getNamespaceMapping();
        if (ns_map != null) {
            Namespace[] ns_array = new Namespace[ns_map.size()];
            int n = 0;
            for (Map.Entry entry : ns_map.entrySet()) {
                String namespace = (String)entry.getKey();
                String prefix = (String)entry.getValue();
                ns_array[n] = new Namespace();
                ns_array[n].setUrl(namespace);
                ns_array[n].setPrefix(prefix);
                ++n;
            }
            return ns_array;
        }
        return null;
    }

    public Schema loadSchema(CompositeMap schema_config) {
        Schema schema = new Schema();
        schema.setSchemaManager(this);
        Namespace[] ns = this.getNameSpaces(schema_config);
        schema.addNameSpaces(ns);
        this.mOcManager.populateObject(schema_config, schema);
        schema.doAssemble();
        this.addSchema(schema);
        return schema;
    }

    public Schema loadSchemaByFile(String source_file) throws IOException, SAXException {
        CompositeMap map = null;
        map = this.mCompositeLoader.loadByFullFilePath(source_file);
        return this.loadSchema(map);
    }

    public Schema loadSchemaFromClassPath(String class_path, String extension) throws IOException, SAXException {
        CompositeMap map = this.mCompositeLoader.loadFromClassPath(class_path, extension);
        return this.loadSchema(map);
    }

    public Schema loadSchemaFromClassPath(String class_path) throws IOException, SAXException {
        return this.loadSchemaFromClassPath(class_path, DEFAULT_EXTENSION);
    }

    public void addSchema(Schema schema) {
        this.mNamedObjectManager.putAll(schema.mNamedObjectManager);
        schema.resolveReference();
    }

    public OCManager getOCManager() {
        return this.mOcManager;
    }

    public void setOCManager(OCManager ocManager) {
        this.mOcManager = ocManager;
        this.initOCManager();
    }

    public Collection getAllTypes() {
        return this.mNamedObjectManager.getObjectMap(0).values();
    }

    public Element getElement(CompositeMap data) {
        Element parent_element;
        CompositeMap parent;
        QualifiedName qname = data.getQName();
        Element element = this.getElement(qname);
        if (element == null && (parent = data.getParent()) != null && (parent_element = this.getElement(parent)) != null) {
            element = parent_element.getElement(qname);
        }
        return element;
    }

    public void addAll(SchemaManager another) {
        this.mNamedObjectManager.addAll(another.mNamedObjectManager);
    }

    public void setParent(SchemaManager parent) {
        this.parent = parent;
    }

    public SchemaManager getParent() {
        return this.parent;
    }

    public List getElementsOfType(IType parent_type) {
        ArrayList<Element> result = new ArrayList<Element>();
        if (this.mNamedObjectManager.getObjectMap(0).values() == null) {
            return null;
        }
        for (Object next : this.mNamedObjectManager.getObjectMap(0).values()) {
            Element ele;
            if (!(next instanceof Element) || !(ele = (Element)next).isExtensionOf(parent_type)) continue;
            result.add(ele);
        }
        return result;
    }
}

