/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.excelreport;

import aurora.plugin.excelreport.ExcelFactory;
import aurora.plugin.excelreport.FontWrap;
import aurora.plugin.excelreport.IndexedCellStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;

public class CellStyleWrap {
    String align;
    String vertical;
    String borderRight;
    String borderLeft;
    String borderBottom;
    String borderTop;
    String bottomBorderColor;
    String leftBorderColor;
    String rightBorderColor;
    String topBorderColor;
    String backgroundColor;
    String foregroundColor;
    String pattern;
    boolean hidden;
    FontWrap fontWrap;
    short indent;
    boolean locked;
    short rotation;
    boolean wrapped;
    String dataFormat;
    String name;
    final String KEY_ALIGN_LEFT = "ALIGN_LEFT";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getVertical() {
        return this.vertical;
    }

    public void setVertical(String vertical) {
        this.vertical = vertical;
    }

    public String getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(String borderRight) {
        this.borderRight = borderRight;
    }

    public String getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(String borderLeft) {
        this.borderLeft = borderLeft;
    }

    public String getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(String borderBottom) {
        this.borderBottom = borderBottom;
    }

    public String getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(String borderTop) {
        this.borderTop = borderTop;
    }

    public String getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public void setBottomBorderColor(String bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
    }

    public String getLeftBorderColor() {
        return this.leftBorderColor;
    }

    public void setLeftBorderColor(String leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    public String getRightBorderColor() {
        return this.rightBorderColor;
    }

    public void setRightBorderColor(String rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
    }

    public String getTopBorderColor() {
        return this.topBorderColor;
    }

    public void setTopBorderColor(String topBorderColor) {
        this.topBorderColor = topBorderColor;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(String foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public FontWrap getFont() {
        return this.fontWrap;
    }

    public void addFont(FontWrap font) {
        this.fontWrap = font;
    }

    public short getIndent() {
        return this.indent;
    }

    public void setIndent(short indent) {
        this.indent = indent;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public short getRotation() {
        return this.rotation;
    }

    public void setRotation(short rotation) {
        this.rotation = rotation;
    }

    public boolean getWrapped() {
        return this.wrapped;
    }

    public void setWrapped(boolean wrapped) {
        this.wrapped = wrapped;
    }

    public CellStyle createStyle(Workbook wb) {
        CellStyle style = wb.createCellStyle();
        FontWrap fontObj = this.getFont();
        if (ExcelFactory.isNotNull(fontObj)) {
            Font font = fontObj.createFont(wb);
            style.setFont(font);
        }
        if (ExcelFactory.isNotNull(this.getAlign())) {
            style.setAlignment(IndexedCellStyle.valueOf(this.getAlign()).getIndex());
            if (this.KEY_ALIGN_LEFT.equals(this.getAlign())) {
                style.setIndention(this.getIndent());
            }
        }
        if (ExcelFactory.isNotNull(this.getVertical())) {
            style.setVerticalAlignment(IndexedCellStyle.valueOf(this.getVertical()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getBorderLeft())) {
            style.setBorderLeft(IndexedCellStyle.valueOf(this.getBorderLeft()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getBorderRight())) {
            style.setBorderRight(IndexedCellStyle.valueOf(this.getBorderRight()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getBorderBottom())) {
            style.setBorderBottom(IndexedCellStyle.valueOf(this.getBorderBottom()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getBorderTop())) {
            style.setBorderTop(IndexedCellStyle.valueOf(this.getBorderTop()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getLeftBorderColor())) {
            style.setLeftBorderColor(IndexedColors.valueOf((String)this.getLeftBorderColor()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getRightBorderColor())) {
            style.setRightBorderColor(IndexedColors.valueOf((String)this.getRightBorderColor()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getBottomBorderColor())) {
            style.setBottomBorderColor(IndexedColors.valueOf((String)this.getBottomBorderColor()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getTopBorderColor())) {
            style.setTopBorderColor(IndexedColors.valueOf((String)this.getTopBorderColor()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getBackgroundColor())) {
            style.setFillBackgroundColor(IndexedColors.valueOf((String)this.getBackgroundColor()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getForegroundColor())) {
            style.setFillForegroundColor(IndexedColors.valueOf((String)this.getForegroundColor()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getPattern())) {
            style.setFillPattern(IndexedCellStyle.valueOf(this.getPattern()).getIndex());
        }
        if (ExcelFactory.isNotNull(this.getDataFormat())) {
            style.setDataFormat(wb.createDataFormat().getFormat(this.getDataFormat()));
        }
        style.setHidden(this.getHidden());
        style.setLocked(this.getLocked());
        style.setWrapText(this.getWrapped());
        style.setRotation(this.getRotation());
        return style;
    }
}

