/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import aurora.database.IResultSetConsumer;
import aurora.database.service.SqlServiceContext;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import aurora.plugin.export.MergedHeader;
import aurora.plugin.poi.BigGridUtil;
import aurora.plugin.poi.Excel2007;
import aurora.plugin.poi.ExcelCellStyles;
import aurora.plugin.poi.SpreadsheetWriter;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.event.IContextAcceptable;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class Excel2007Output
implements IResultSetConsumer,
IContextAcceptable {
    private static final String XML_ENCODING = "UTF-8";
    private static int CELL_CHAR_LIMIT = (int)Math.pow(2.0, 15.0) - 1;
    private static String TRUNCATE_WARNING = "DATA TRUNCATED";
    Map<Integer, CompositeMap> columnMap = new TreeMap<Integer, CompositeMap>();
    Map<Integer, Map<Integer, String>> headMap = new TreeMap<Integer, Map<Integer, String>>();
    Map<String, Object> rowMap;
    int headLevel;
    Excel2007 excel2007 = new Excel2007();
    ExcelCellStyles styles;
    File rawSheet;
    File templateFile;
    SpreadsheetWriter sw;
    String sheetName;
    ServiceContext context;
    ILogger mLogger;
    IObjectRegistry mObjectRegistry;
    ILocalizedMessageProvider localMsgProvider;

    public Excel2007Output(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
        this.mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
    }

    public void setContext(CompositeMap context) {
        this.context = (SqlServiceContext)DynamicObject.cast((CompositeMap)context, SqlServiceContext.class);
        IMessageProvider msgProvider = (IMessageProvider)this.mObjectRegistry.getInstanceOfType(IMessageProvider.class);
        String langString = this.context.getSession().getString((Object)"lang", "ZHS");
        this.localMsgProvider = msgProvider.getLocalizedMessageProvider(langString);
        Writer rawWriter = null;
        try {
            this.rawSheet = File.createTempFile("Excel2007TempSheet", ".xml");
            rawWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.rawSheet), XML_ENCODING);
            this.sw = new SpreadsheetWriter(rawWriter, XML_ENCODING);
            this.createExcelHeader(this.getHeaderConfig());
        }
        catch (Exception e) {
            if (rawWriter != null) {
                try {
                    rawWriter.close();
                }
                catch (IOException e1) {
                    this.mLogger.log(Level.SEVERE, e1.getMessage());
                }
            }
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    CompositeMap getHeaderConfig() throws ServletException {
        CompositeMap columnConfig = (CompositeMap)this.context.getParameter().getObject("_column_config_/column");
        if (columnConfig == null) {
            throw new ServletException("service-output tag and output attibute must be defined");
        }
        return new MergedHeader((CompositeMap)columnConfig).conifg;
    }

    void createExcelHeader(CompositeMap headerConfig) throws Exception {
        OutputStream os = null;
        Workbook wb = this.excel2007.getNewWorkbook();
        this.styles = new ExcelCellStyles(wb);
        Sheet sheet = wb.createSheet();
        this.sheetName = ((XSSFSheet)sheet).getPackagePart().getPartName().getName();
        Row header = sheet.createRow(0);
        this.generatExcelHead(headerConfig, sheet, header, -1);
        try {
            this.templateFile = File.createTempFile("Excel2007TempTemplate", ".xlsx");
            os = new FileOutputStream(this.templateFile);
            wb.write(os);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    int generatExcelHead(CompositeMap columnConfigs, Sheet sheet, Row header, int col) {
        int rownum = header.getRowNum();
        Iterator iterator = columnConfigs.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Iterator it;
                ++col;
                CompositeMap record = (CompositeMap)iterator.next();
                String title = this.getPrompt(record.getString((Object)"prompt"));
                Map<Integer, String> map = this.headMap.get(rownum);
                if (map != null) {
                    map.put(col, title);
                } else {
                    map = new TreeMap<Integer, String>();
                    map.put(col, title);
                    this.headMap.put(rownum, map);
                }
                int level = record.getInt((Object)"_level", 0);
                if (this.headLevel == 0) {
                    this.headLevel = level;
                }
                if ((it = record.getChildIterator()) != null) {
                    Long span = (Long)record.getObject("column/@_count");
                    CellRangeAddress range = new CellRangeAddress(rownum, rownum, col, col + span.intValue() - 1);
                    this.sw.addMergedRegion(range);
                    while (it.hasNext()) {
                        Row nextRow = sheet.getRow(rownum + 1);
                        if (nextRow == null) {
                            nextRow = sheet.createRow(rownum + 1);
                        }
                        CompositeMap object = (CompositeMap)it.next();
                        col = this.generatExcelHead(object, sheet, nextRow, col - 1);
                    }
                    continue;
                }
                this.columnMap.put(col, record);
                int width = record.getInt((Object)"width", 100);
                this.sw.setCellWidth(col + 1, (short)(width / 6));
                if (level == 0) continue;
                CellRangeAddress range = new CellRangeAddress(rownum, rownum + level, col, col);
                this.sw.addMergedRegion(range);
            }
        }
        return col;
    }

    public void begin(String root_name) {
        short headerStyleIndex = this.styles.getHeaderStyle().getIndex();
        try {
            this.sw.beginSheet();
            Set<Integer> keySet = this.headMap.keySet();
            for (Integer row : keySet) {
                this.sw.insertRow(row);
                Map<Integer, String> map = this.headMap.get(row);
                Set<Integer> colSet = map.keySet();
                for (Integer col : colSet) {
                    this.sw.createCell((int)col, map.get(col), (int)headerStyleIndex);
                }
                this.sw.endRow();
            }
        }
        catch (IOException e) {
            try {
                this.sw.close();
            }
            catch (IOException e1) {
                this.mLogger.log(Level.SEVERE, e1.getMessage());
                throw new RuntimeException(e1);
            }
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void newRow(String row_name) {
        ++this.headLevel;
        if (this.headLevel > this.excel2007.getRowLimit()) {
            return;
        }
        try {
            this.sw.insertRow(this.headLevel);
            this.rowMap = new HashMap<String, Object>();
        }
        catch (IOException e) {
            try {
                this.sw.close();
            }
            catch (IOException e1) {
                this.mLogger.log(Level.SEVERE, e1.getMessage());
                throw new RuntimeException(e1);
            }
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void loadField(String name, Object value) {
        this.rowMap.put(name, value);
    }

    public void endRow() {
        Set<Integer> keySet = this.columnMap.keySet();
        Iterator<Integer> iterator = keySet.iterator();
        try {
            while (iterator.hasNext()) {
                Integer key = iterator.next();
                Object att = this.rowMap.get(this.columnMap.get(key).getString((Object)"name"));
                int col = key;
                if (col > this.excel2007.getColLimit()) break;
                if (att == null) continue;
                if (att instanceof Number) {
                    this.sw.createCell(col, ((Number)att).doubleValue());
                    continue;
                }
                if (att instanceof Calendar) {
                    this.sw.createCell(col, (Calendar)att, (int)this.styles.getDateStyle().getIndex());
                    continue;
                }
                if (att instanceof Boolean) {
                    this.sw.createCell(col, (Boolean)att);
                    continue;
                }
                String stringVal = att.toString();
                if (stringVal.length() > CELL_CHAR_LIMIT) {
                    stringVal = TRUNCATE_WARNING + " " + stringVal.substring(0, CELL_CHAR_LIMIT - TRUNCATE_WARNING.length() - 1);
                    this.sw.createCell(col, stringVal, (int)this.styles.getWarningStyle().getIndex());
                    continue;
                }
                this.sw.createCell(col, stringVal);
            }
            this.sw.endRow();
        }
        catch (IOException e) {
            try {
                this.sw.close();
            }
            catch (IOException e1) {
                this.mLogger.log(Level.SEVERE, e1.getMessage());
                throw new RuntimeException(e1);
            }
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void end() {
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)this.context.getObjectContext());
        HttpServletResponse response = ((HttpServiceInstance)svc).getResponse();
        this.setResponseHeader(response);
        ServletOutputStream out = null;
        try {
            this.sw.endSheet();
        }
        catch (IOException e) {
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.sw.close();
            }
            catch (IOException e1) {
                this.mLogger.log(Level.SEVERE, e1.getMessage());
                throw new RuntimeException(e1);
            }
        }
        try {
            out = response.getOutputStream();
            BigGridUtil.substitute(this.templateFile, this.rawSheet, this.sheetName.substring(1), (OutputStream)out);
        }
        catch (IOException e) {
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
        this.templateFile.delete();
        this.rawSheet.delete();
    }

    public void setRecordCount(long count) {
    }

    public Object getResult() {
        return null;
    }

    String getPrompt(String key) {
        String promptString = this.localMsgProvider.getMessage(key);
        promptString = promptString == null ? key : promptString;
        return promptString;
    }

    void setResponseHeader(HttpServletResponse response) {
        String fileName = "excel";
        response.setContentType(this.excel2007.getMimeType());
        response.setCharacterEncoding(XML_ENCODING);
        response.setHeader("cache-control", "must-revalidate");
        response.setHeader("pragma", "public");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + this.excel2007.getFileExtension() + "\"");
    }
}

