/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.quartz;

import aurora.plugin.quartz.AuroraJobDetail;
import aurora.plugin.quartz.SchedulerConfig;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import uncertain.core.UncertainEngine;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;

public class AuroraStatefulJobRunner
implements StatefulJob {
    public static final String DEFAULT_METHOD_NAME = "run";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        IObjectRegistry os = SchedulerConfig.getObjectRegistry(context.getJobDetail().getJobDataMap());
        AuroraJobDetail detail = (AuroraJobDetail)context.getJobDetail();
        Class cls_to_run = detail.getTargetJobClass();
        String method = detail.getMethod();
        if (method == null) {
            method = DEFAULT_METHOD_NAME;
        }
        try {
            Method[] marray = cls_to_run.getMethods();
            Method job_method = null;
            for (int i = 0; i < marray.length; ++i) {
                if (!marray[i].getName().equals(method)) continue;
                job_method = marray[i];
                break;
            }
            if (job_method == null) {
                throw new JobExecutionException("'method' property not set in job detail config");
            }
            Class<?>[] types = job_method.getParameterTypes();
            Object[] args = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                args[i] = JobExecutionContext.class.equals(types[i]) ? context : os.getInstanceOfType(types[i]);
            }
            UncertainEngine engine = (UncertainEngine)os.getInstanceOfType(UncertainEngine.class);
            Object instance = engine.getObjectCreator().createInstance(cls_to_run);
            OCManager om = engine.getOcManager();
            om.populateObject(detail.getConfig(), instance);
            job_method.invoke(instance, args);
        }
        catch (Exception ex) {
            LoggingContext.getLogger((String)this.getClass().getCanonicalName(), (IObjectRegistry)os).log(Level.SEVERE, "", (Throwable)ex);
            throw new JobExecutionException(ex);
        }
    }
}

