/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script.engine;

import aurora.plugin.script.engine.CompiledScriptCache;
import aurora.plugin.script.engine.InterruptException;
import aurora.plugin.script.engine.RhinoClassShutter;
import aurora.plugin.script.engine.RhinoWrapFactory;
import aurora.plugin.script.engine.ScriptImportor;
import aurora.plugin.script.scriptobject.ActionEntryObject;
import aurora.plugin.script.scriptobject.CompositeMapBuilder;
import aurora.plugin.script.scriptobject.CompositeMapObject;
import aurora.plugin.script.scriptobject.CookieObject;
import aurora.plugin.script.scriptobject.ModelServiceObject;
import aurora.plugin.script.scriptobject.ScriptShareObject;
import aurora.plugin.script.scriptobject.ScriptUtil;
import aurora.plugin.script.scriptobject.SessionObject;
import aurora.service.ServiceInstance;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;

public class AuroraScriptEngine {
    public static final String aurora_core_js = "aurora-core.js";
    public static final String KEY_SERVICE_CONTEXT = "service_context";
    public static final String KEY_SSO = "sso";
    private static String js = ScriptUtil.loadAuroraCore();
    private static TopLevel topLevel = null;
    private Scriptable scope = null;
    private static Set<String> executedInTopLevel;
    private CompositeMap service_context;
    private int optimizeLevel = -1;

    public AuroraScriptEngine(CompositeMap context) {
        if (context == null) {
            throw new NullPointerException("init context for 'AuroraScriptEngine' can not be null.");
        }
        this.service_context = context;
        IObjectRegistry or = ((ScriptShareObject)this.service_context.get((Object)KEY_SSO)).getObjectRegistry();
        UncertainEngine engine = (UncertainEngine)or.getInstanceOfType(UncertainEngine.class);
        CompiledScriptCache.createInstanceNE(engine);
    }

    private void preDefine(Context cx, Scriptable scope) {
        Scriptable ctx = cx.newObject(scope, "CompositeMap", new Object[]{this.service_context});
        ScriptableObject.defineProperty((Scriptable)scope, (String)"$ctx", (Object)ctx, (int)1);
        this.definePropertyForCtx((CompositeMapObject)ctx, cx, this.service_context);
        Scriptable ses = cx.newObject(scope, "Session", new Object[]{this.service_context});
        ScriptableObject.defineProperty((Scriptable)scope, (String)"$session", (Object)ses, (int)1);
        Scriptable cok = cx.newObject(scope, "Cookie");
        ScriptableObject.defineProperty((Scriptable)scope, (String)"$cookie", (Object)cok, (int)1);
    }

    private void definePropertyForCtx(CompositeMapObject ctx, Context cx, CompositeMap service_context) {
        String[] names;
        for (String s : names = new String[]{"parameter", "session", "cookie", "model"}) {
            CompositeMap p = service_context.getChild(s);
            if (p == null) {
                p = service_context.createChild(s);
            }
            ctx.definePrivateProperty(s, cx.newObject((Scriptable)ctx, "CompositeMap", new Object[]{p}));
        }
    }

    private static void initTopLevel(Context cx) {
        topLevel = new ImporterTopLevel(cx);
        try {
            ScriptableObject.defineClass((Scriptable)topLevel, CompositeMapObject.class);
            ScriptableObject.defineClass((Scriptable)topLevel, SessionObject.class);
            ScriptableObject.defineClass((Scriptable)topLevel, CookieObject.class);
            ScriptableObject.defineClass((Scriptable)topLevel, ModelServiceObject.class);
            ScriptableObject.defineClass((Scriptable)topLevel, ActionEntryObject.class);
            topLevel.defineFunctionProperties(new String[]{"print", "println", "raise_app_error", "$instance", "$cache", "$config", "$bm", "$define"}, AuroraScriptEngine.class, 2);
            cx.evaluateString((Scriptable)topLevel, js, aurora_core_js, 1, null);
            ScriptableObject cmBuilder = (ScriptableObject)cx.newObject((Scriptable)topLevel);
            ScriptableObject.defineProperty((Scriptable)topLevel, (String)"CompositeMapBuilder", (Object)cmBuilder, (int)2);
            Method[] ms = CompositeMapBuilder.class.getDeclaredMethods();
            ArrayList<String> als = new ArrayList<String>();
            int mod = 9;
            for (Method m : ms) {
                if ((m.getModifiers() & mod) != mod) continue;
                als.add(m.getName());
            }
            String[] names = als.toArray(new String[als.size()]);
            cmBuilder.defineFunctionProperties(names, CompositeMapBuilder.class, 2);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Object eval(String source) throws Exception {
        Object ret = null;
        Context cx = Context.enter();
        try {
            cx.putThreadLocal((Object)KEY_SERVICE_CONTEXT, (Object)this.service_context);
            cx.setOptimizationLevel(this.optimizeLevel);
            if (this.scope == null) {
                this.scope = cx.newObject((Scriptable)topLevel);
                this.scope.setParentScope(null);
                this.scope.setPrototype((Scriptable)topLevel);
                this.preDefine(cx, this.scope);
            }
            ScriptImportor.organizeUserImport(cx, this.scope, this.service_context);
            Script scr = CompiledScriptCache.getInstance().getScript(source, cx);
            ret = scr == null ? null : scr.exec(cx, this.scope);
        }
        catch (RhinoException re) {
            if (re.getCause() instanceof InterruptException) {
                throw (InterruptException)re.getCause();
            }
            throw re;
        }
        finally {
            Context.exit();
        }
        if (ret instanceof Wrapper) {
            ret = ((Wrapper)ret).unwrap();
        } else if (ret instanceof Undefined) {
            ret = null;
        }
        return ret;
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                System.out.print(" ");
            }
            String s = Context.toString((Object)args[i]);
            System.out.print(s);
        }
    }

    public static void println(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        AuroraScriptEngine.print(cx, thisObj, args, funObj);
        System.out.println();
    }

    public static void raise_app_error(String err_code) throws InterruptException {
        throw new InterruptException(err_code);
    }

    public static Object $instance(String className) {
        return ScriptUtil.getInstanceOfType(className);
    }

    public static Object $cache(String cacheName) {
        CompositeMap ctx = ScriptUtil.getContext();
        IObjectRegistry reg = ScriptUtil.getObjectRegistry(ctx);
        INamedCacheFactory cf = (INamedCacheFactory)reg.getInstanceOfType(INamedCacheFactory.class);
        return cf.getNamedCache(cacheName);
    }

    public static Object $config(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ServiceInstance si = ServiceInstance.getInstance((CompositeMap)ScriptUtil.getContext());
        Script scr = CompiledScriptCache.getInstance().getScript("importClass(Packages.uncertain.composite.CompositeUtil)", cx, "<Import CompositeUtil>");
        if (scr != null) {
            scr.exec(cx, thisObj);
        }
        return si.getServiceConfigData();
    }

    public static Object $bm(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ModelServiceObject bm = (ModelServiceObject)cx.newObject(thisObj, "ModelService", args);
        if (args.length > 1) {
            bm.jsSet_option(args[1]);
        }
        return bm;
    }

    public static void $define(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        Script script;
        if (args.length == 0 || !(args[0] instanceof String)) {
            return;
        }
        String jspath = (String)args[0];
        String jspath_low = jspath.toLowerCase();
        CompositeMap context = (CompositeMap)cx.getThreadLocal((Object)KEY_SERVICE_CONTEXT);
        if (!executedInTopLevel.contains(jspath_low)) {
            ScriptImportor.defineExternScript(cx, (Scriptable)topLevel, context, jspath);
            executedInTopLevel.add(jspath_low);
            return;
        }
        ScriptShareObject sso = (ScriptShareObject)context.get((Object)KEY_SSO);
        if (sso == null) {
            return;
        }
        File jsFile = ScriptImportor.getJsFile(sso, jspath);
        if (CompiledScriptCache.getInstance().isChanged(jsFile, cx) && (script = CompiledScriptCache.getInstance().getScript(jsFile, cx)) != null) {
            script.exec(cx, (Scriptable)topLevel);
        }
    }

    public void setOptimizeLevel(int level) {
        this.optimizeLevel = level;
    }

    static {
        RhinoException.useMozillaStackStyle((boolean)false);
        AuroraScriptEngine.initTopLevel(Context.enter());
        Context.exit();
        ContextFactory.initGlobal((ContextFactory)new ContextFactory(){

            protected Context makeContext() {
                Context cx = super.makeContext();
                cx.setLanguageVersion(180);
                cx.setOptimizationLevel(-1);
                cx.setClassShutter(RhinoClassShutter.getInstance());
                cx.setWrapFactory(RhinoWrapFactory.getInstance());
                return cx;
            }
        });
        executedInTopLevel = new HashSet<String>();
    }
}

