/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.ApplicationConfig;
import aurora.application.ApplicationViewConfig;
import aurora.application.IApplicationConfig;
import aurora.application.config.ScreenConfig;
import aurora.application.features.CachedScreenListener;
import aurora.database.profile.IDatabaseFactory;
import aurora.i18n.DummyMessageProvider;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import aurora.presentation.BuildSession;
import aurora.presentation.PresentationManager;
import aurora.presentation.cache.IResponseCacheProvider;
import aurora.service.IService;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uncertain.cache.ICache;
import uncertain.composite.CompositeMap;
import uncertain.event.Configuration;
import uncertain.event.RuntimeContext;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IFeature;
import uncertain.proc.ProcedureRunner;

public class ScreenRenderer
implements IFeature {
    public static final String HTML_PAGE = "html-page";
    private static final String DEFAULT_LANG_CODE = "ZHS";
    private String contentType = "text/html;charset=utf-8";
    PresentationManager mPrtManager;
    HttpServiceInstance mService;
    CompositeMap mContext;
    CompositeMap mScreen;
    IResponseCacheProvider mCacheProvider;
    IDatabaseFactory databaseFactory;
    IObjectRegistry mRegistry;
    IMessageProvider mMessageProvider;
    ApplicationConfig mApplicationConfig;
    String mDefaultPackage;
    String mDefaultTemplate;
    String mDefaultLabelSeparator;
    boolean mIsCache = false;

    public ScreenRenderer(PresentationManager prtManager, IObjectRegistry registry, IDatabaseFactory factory) {
        ApplicationViewConfig view_config;
        this.mPrtManager = prtManager;
        this.mRegistry = registry;
        this.databaseFactory = factory;
        this.mCacheProvider = (IResponseCacheProvider)this.mRegistry.getInstanceOfType(IResponseCacheProvider.class);
        this.mMessageProvider = (IMessageProvider)this.mRegistry.getInstanceOfType(IMessageProvider.class);
        if (this.mMessageProvider == null) {
            this.mMessageProvider = DummyMessageProvider.DEFAULT_INSTANCE;
        }
        this.mApplicationConfig = (ApplicationConfig)this.mRegistry.getInstanceOfType(IApplicationConfig.class);
        if (this.mApplicationConfig != null && (view_config = this.mApplicationConfig.getApplicationViewConfig()) != null) {
            this.mDefaultPackage = view_config.getDefaultPackage();
            this.mDefaultTemplate = view_config.getDefaultTemplate();
        }
    }

    public int onCreateView(ProcedureRunner runner) {
        this.mContext = runner.getContext();
        this.mService = (HttpServiceInstance)ServiceInstance.getInstance(this.mContext);
        ScreenConfig cfg = ScreenConfig.createScreenConfig(this.mService.getServiceConfigData());
        this.mIsCache = cfg.isCacheEnabled();
        this.mScreen = cfg.getViewConfig();
        if (this.mScreen != null) {
            File source = this.mScreen.getSourceFile();
            if (source != null) {
                this.mScreen.setSourceFile(source);
            }
            this.mScreen.setName(HTML_PAGE);
            this.mScreen.setNameSpaceURI(null);
            if (this.mScreen.getString("template") == null) {
                this.mScreen.putString("template", this.mDefaultTemplate);
            }
            if (this.mScreen.getString("package") == null) {
                this.mScreen.putString("package", this.mDefaultPackage);
            }
            if (this.mScreen.getString("labelseparator") != null) {
                this.mDefaultLabelSeparator = this.mScreen.getString("labelseparator");
            }
            if (this.mScreen.getString("contenttype") != null) {
                this.setContentType(this.mScreen.getString("contenttype"));
            }
            this.mContext.putBoolean("output", true);
        }
        return 0;
    }

    public int onBuildOutputContent(ProcedureRunner runner) throws Exception {
        if (this.mScreen == null) {
            return 0;
        }
        CompositeMap context = runner.getContext();
        ILogger logger = LoggingContext.getLogger(context, "aurora.presentation.buildsession");
        RuntimeContext ctx = ServiceContext.getInstance(context);
        BuildSession session = (BuildSession)ctx.getInstanceOfType(BuildSession.class);
        if (session == null) {
            ByteArrayOutputStream baos = null;
            Writer out = null;
            HttpServletResponse response = this.mService.getResponse();
            HttpServletRequest request = this.mService.getRequest();
            response.setContentType(this.getContentType());
            if (this.mIsCache) {
                baos = new ByteArrayOutputStream();
                out = new OutputStreamWriter(baos);
            } else {
                out = response.getWriter();
            }
            session = this.mPrtManager.createSession(out);
            session.setContextPath(request.getContextPath());
            CompositeMap dbProperties = this.databaseFactory.getProperties();
            if (dbProperties == null) {
                throw new Exception("Database Properties undifined");
            }
            String language_code = this.getLanguageCode(runner, this.mService, dbProperties.getString("language_path"), this.mMessageProvider.getDefaultLang());
            session.setLanguage(language_code);
            ILocalizedMessageProvider lp = this.mMessageProvider.getLocalizedMessageProvider(language_code);
            session.setMessageProvider(lp);
            Cookie[] cookies = request.getCookies();
            ApplicationViewConfig view_config = this.mApplicationConfig.getApplicationViewConfig();
            String appTheme = view_config.getDefaultTheme();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    Cookie cookie = cookies[i];
                    String cname = cookie.getName();
                    if (!"app_theme".equals(cname)) continue;
                    appTheme = cookie.getValue();
                }
            }
            session.getSessionContext().put("labelseparator", this.mDefaultLabelSeparator);
            session.setTheme(appTheme);
            session.setBaseConfig(this.mService.getServiceConfig());
            session.setInstanceOfType(IService.class, this.mService);
            session.setLogger(logger);
            ctx.setInstanceOfType(BuildSession.class, session);
            session.buildView(this.mService.getServiceContext().getModel(), this.mScreen);
            out.flush();
            if (this.mIsCache && this.mCacheProvider != null) {
                String output = baos.toString();
                ICache cache = this.mCacheProvider.getCacheForResponse();
                String key = CachedScreenListener.getCacheKey(context);
                if (key != null) {
                    cache.setValue(key, output);
                }
                PrintWriter response_writer = response.getWriter();
                response_writer.write(output);
                response_writer.flush();
            }
        } else {
            IService oldService = (IService)session.getInstanceOfType(IService.class);
            session.setInstanceOfType(IService.class, this.mService);
            session.buildViewFromBegin(this.mService.getServiceContext().getModel(), this.mScreen);
            session.setInstanceOfType(IService.class, oldService);
            session.getWriter().flush();
        }
        return 1;
    }

    private String getLanguageCode(ProcedureRunner runner, HttpServiceInstance service, String langPath, String defaultLange) {
        String langCode = "";
        CompositeMap context = runner.getContext();
        if (!"".equals(langPath)) {
            Object lo = context.getObject(langPath);
            String string = langCode = lo != null ? lo.toString() : "";
        }
        if ("".equals(langCode) && !"".equals(defaultLange)) {
            langCode = defaultLange;
        }
        if ("".equals(langCode)) {
            HttpServletRequest request = service.getRequest();
            String acceptLanguage = request.getHeader("Accept-Language");
            langCode = this.translateLanguageCode(acceptLanguage.toLowerCase());
        }
        return langCode;
    }

    private String translateLanguageCode(String acceptLanguage) {
        String code = DEFAULT_LANG_CODE;
        if (acceptLanguage.indexOf("zh-cn") != -1) {
            code = DEFAULT_LANG_CODE;
        } else if (acceptLanguage.indexOf("en-us") != -1) {
            code = "US";
        }
        return code;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public int attachTo(CompositeMap config_data, Configuration config) {
        return 0;
    }
}

