/*
 * Decompiled with CFR 0.152.
 */
package aurora.bm;

import aurora.bm.Reference;
import aurora.database.sql.Join;
import java.util.Iterator;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;

public class Relation
extends DynamicObject {
    public static final String KEY_REF_ALIAS = "refalias";
    public static final String KEY_JOIN_TYPE = "jointype";
    public static final String KEY_NAME = "name";
    public static final String KEY_REFERENCE_MODEL = "refmodel";

    public static Relation getInstance(CompositeMap context) {
        Relation relation = new Relation();
        relation.initialize(context);
        return relation;
    }

    public String getReferenceModel() {
        return this.getString(KEY_REFERENCE_MODEL);
    }

    public void setReferenceModel(String ref) {
        this.put(KEY_REFERENCE_MODEL, ref);
    }

    public String getReferenceAlias() {
        String str = this.getString(KEY_REF_ALIAS);
        if (str == null) {
            str = this.getName();
        }
        return str;
    }

    public void setReferenceAlias(String alias) {
        this.putString(KEY_REF_ALIAS, alias);
    }

    public String getName() {
        String name = this.getString(KEY_NAME);
        if (name == null) {
            name = this.getReferenceModel();
        }
        return name;
    }

    public void setName(String name) {
        this.putString(KEY_NAME, name);
    }

    public String getJoinType() {
        String type = this.getString(KEY_JOIN_TYPE);
        return type == null ? "INNER JOIN" : type.toUpperCase();
    }

    public void setJoinType(String join_type) {
        if (!Join.isTypeValid(join_type)) {
            throw new IllegalArgumentException("Invalid join type:" + join_type);
        }
        this.putString(KEY_JOIN_TYPE, join_type.toUpperCase());
    }

    @Override
    public void checkValidation() {
        String type = this.getJoinType();
        if (!Join.isTypeValid(type)) {
            throw new IllegalArgumentException("<relation>: Invalid join type:" + type);
        }
        if (this.getReferenceModel() == null) {
            throw new IllegalArgumentException("<relation>: Must set 'reference' property");
        }
    }

    public Reference[] getReferences() {
        Iterator it = this.getObjectContext().getChildIterator();
        if (it == null) {
            return null;
        }
        Reference[] refs = new Reference[this.getObjectContext().getChilds().size()];
        int i = 0;
        while (it.hasNext()) {
            Reference ref = Reference.getInstance((CompositeMap)it.next());
            refs[i++] = ref;
        }
        return refs;
    }

    public boolean isNeedDatabaseJoin() {
        return this.getBoolean("_needdatabasejoin", true);
    }

    public void setNeedDatabaseJoin(boolean b) {
        this.putBoolean("_needdatabasejoin", b);
    }
}

