/*
 * Decompiled with CFR 0.152.
 */
package aurora.database;

import aurora.database.BindParameter;
import aurora.service.validation.Parameter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import uncertain.util.QuickTagParser;
import uncertain.util.TagParseHandle;

public class ParsedSql {
    public static final char DYNAMIC_SQL_INDICATOR = ':';
    StringBuffer parsed_sql = new StringBuffer();
    String origin_sql;
    LinkedList parameter_list;
    HashMap parameter_map;
    SQLParseHandle handle = new SQLParseHandle();
    boolean static_statement = true;
    boolean has_output_parameter = false;
    boolean has_auto_generated_key = false;

    public ParsedSql() {
        this.parameter_list = new LinkedList();
        this.parameter_map = new HashMap();
    }

    public ParsedSql(String sql_with_tag) {
        this();
        this.parse(sql_with_tag);
    }

    public void defineParameter(Parameter param) {
        this.defineParameter(param, true);
    }

    public void defineParameter(Parameter param, boolean override) {
        if (!override && this.parameter_map.containsKey(param.getInputPath())) {
            return;
        }
        this.parameter_map.put(param.getInputPath(), param);
    }

    public void defineParameters(Collection param_list) {
        this.defineParameters(param_list, true);
    }

    public void defineParameters(Collection param_list, boolean override) {
        for (Parameter param : param_list) {
            this.defineParameter(param, override);
        }
    }

    void addParameter(BindParameter param) {
        Parameter p = (Parameter)this.parameter_map.get(param.input_path);
        if (p != null) {
            param.copyFrom(p);
        }
        if (param.is_output) {
            this.has_output_parameter = true;
        }
        if (param.isAutoGeneratedKey) {
            this.has_auto_generated_key = true;
        }
        this.parameter_list.add(param);
    }

    public void parse(String sql) {
        this.origin_sql = sql;
        this.parsed_sql.setLength(0);
        this.parameter_list.clear();
        QuickTagParser parser = new QuickTagParser();
        parser.parse(sql, (TagParseHandle)this.handle);
        parser.clear();
    }

    public List getBindParameters() {
        return this.parameter_list;
    }

    public String getParsedSQL() {
        return this.parsed_sql.toString();
    }

    public String getOriginSQL() {
        return this.origin_sql;
    }

    public boolean isStaticStatement() {
        return this.static_statement;
    }

    public boolean hasOutputParameter() {
        return this.has_output_parameter;
    }

    public void setStaticStatement(boolean static_statement) {
        this.static_statement = static_statement;
    }

    public boolean hasAutoGeneratedKey() {
        return this.has_auto_generated_key;
    }

    public void setHasAutoGeneratedKey(boolean has_auto_generated_key) {
        this.has_auto_generated_key = has_auto_generated_key;
    }

    class SQLParseHandle
    implements TagParseHandle {
        @Override
        public String ProcessTag(int index, String tag) {
            if (tag.length() == 0) {
                return "";
            }
            BindParameter param = new BindParameter(tag);
            param.position = ParsedSql.this.parsed_sql.length();
            String replacement = null;
            if (tag.charAt(0) == ':') {
                param.input_path = tag = tag.substring(1);
                param.is_sql_statement = true;
                ParsedSql.this.static_statement = false;
                replacement = "";
            } else {
                replacement = "?";
            }
            ParsedSql.this.addParameter(param);
            ParsedSql.this.parsed_sql.append(replacement);
            return replacement;
        }

        @Override
        public int ProcessCharacter(int index, char ch) {
            ParsedSql.this.parsed_sql.append(ch);
            return ch;
        }
    }
}

