/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics.cvs;

import java.util.HashMap;
import java.util.StringTokenizer;

public class CVSRepositoryLocation {
    public static final char COLON = ':';
    public static final char SEMICOLON = ';';
    public static final char HOST_SEPARATOR = '@';
    public static final char PORT_SEPARATOR = '#';
    public static int USE_DEFAULT_PORT = 0;
    private String methodName;
    private String userName;
    private String password;
    private String host;
    private int port;
    private String root;

    public CVSRepositoryLocation(String root) {
        this.fromString(root);
    }

    public void fromString(String location) {
        try {
            String methodName;
            int end;
            int start = location.indexOf(58);
            int optionStart = location.indexOf(59);
            HashMap<String, String> hmOptions = new HashMap<String, String>();
            if (start == 0) {
                end = location.indexOf(58, start + 1);
                if (optionStart != -1) {
                    methodName = location.substring(start + 1, optionStart);
                    StringTokenizer stOpt = new StringTokenizer(location.substring(optionStart + 1, end), "=;");
                    while (stOpt.hasMoreTokens()) {
                        hmOptions.put(stOpt.nextToken(), stOpt.nextToken());
                    }
                    start = end + 1;
                } else {
                    methodName = location.substring(start + 1, end);
                    start = end + 1;
                }
            } else {
                methodName = "ext";
                start = 0;
            }
            end = location.indexOf(64, start);
            String user = null;
            String password = null;
            if (end != -1) {
                user = location.substring(start, end);
                if ((start = user.indexOf(58)) != -1) {
                    password = user.substring(start + 1);
                    user = user.substring(0, start);
                }
                start = end + 1;
            } else if (optionStart != -1) {
                if (hmOptions.containsKey("username")) {
                    user = hmOptions.get("username").toString();
                }
                if (hmOptions.containsKey("password")) {
                    password = hmOptions.get("password").toString();
                }
            }
            int hostEnd = end = location.indexOf(58, start);
            if (end == -1) {
                hostEnd = end = location.indexOf(47, start);
                if (end != -1) {
                    --end;
                }
            }
            String host = hmOptions.containsKey("hostname") ? hmOptions.get("hostname").toString() : location.substring(start, hostEnd);
            int port = USE_DEFAULT_PORT;
            boolean havePort = false;
            if (hmOptions.containsKey("port")) {
                port = Integer.parseInt(hmOptions.get("port").toString());
                havePort = true;
            }
            if ((start = host.indexOf(35)) != -1) {
                try {
                    port = Integer.parseInt(host.substring(start + 1));
                    host = host.substring(0, start);
                    havePort = true;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (!havePort) {
                int index = end;
                char c = location.charAt(++index);
                String portString = new String();
                while (Character.isDigit(c)) {
                    portString = portString + c;
                    c = location.charAt(++index);
                }
                if (portString.length() > 0) {
                    end = index - 1;
                    port = Integer.parseInt(portString);
                }
            }
            start = end + 1;
            String root = location.substring(start);
            this.methodName = methodName;
            this.userName = user;
            this.password = password;
            this.host = host;
            this.port = port;
            this.root = root;
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }
}

