/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.c3p0;

import aurora.datasource.DatabaseConnection;
import aurora.datasource.IDataSourceFactory;
import aurora.plugin.c3p0.C3P0NativeJdbcExtractor;
import com.mchange.v2.c3p0.C3P0ProxyConnection;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public class DataSourceFactory
implements IDataSourceFactory {
    @Override
    public DataSource createDataSource(DatabaseConnection dbConfig) throws Exception {
        DataSource ds = null;
        ds = DataSources.unpooledDataSource((String)dbConfig.getUrl(), (String)dbConfig.getUserName(), (String)dbConfig.getPassword());
        ((DriverManagerDataSource)ds).setDriverClass(dbConfig.getDriverClass());
        if (dbConfig.getName() != null) {
            ((DriverManagerDataSource)ds).setDescription(dbConfig.getName());
        }
        if (dbConfig.getPool()) {
            ds = dbConfig.getConfig() != null ? DataSources.pooledDataSource((DataSource)ds, (Map)dbConfig.getConfig()) : DataSources.pooledDataSource((DataSource)ds);
        }
        return ds;
    }

    @Override
    public void cleanDataSource(DataSource ds) {
        try {
            ((PooledDataSource)ds).close();
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public Connection getNativeJdbcExtractor(Connection conn) throws Exception {
        Connection nativeConn = null;
        if (conn instanceof C3P0ProxyConnection) {
            C3P0NativeJdbcExtractor nativeJdbcExtractor = new C3P0NativeJdbcExtractor();
            try {
                nativeConn = nativeJdbcExtractor.getNativeConnection(conn);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        return nativeConn;
    }
}

