/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.TextAreaConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class TextArea
extends Component {
    public static final String VERSION = "$Revision: 7048 $";
    private static final String DEFAULT_CLASS = "item-textarea";
    protected static final String CLASSNAME_READONLY = "item-readOnly";

    @Override
    protected int getDefaultWidth() {
        return 150;
    }

    @Override
    protected int getDefaultHeight() {
        return 50;
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        CompositeMap view = context.getView();
        TextAreaConfig tac = TextAreaConfig.getInstance(view);
        String wrapClass = DEFAULT_CLASS;
        if (tac.isReadOnly()) {
            wrapClass = wrapClass + " item-readOnly";
        }
        return wrapClass;
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        Map map = context.getMap();
        TextAreaConfig tac = TextAreaConfig.getInstance(view);
        boolean readOnly = tac.isReadOnly();
        if (readOnly) {
            map.put("readonly", "readonly");
        }
        this.addConfig("readonly", readOnly);
        map.put("tabindex", new Integer(tac.getTabIndex()));
        map.put("config", this.getConfigString());
    }
}

