/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.markup;

import aurora.presentation.ViewContext;
import aurora.presentation.markup.ScriptReference;
import aurora.presentation.markup.StyleSheetReference;
import aurora.presentation.markup.TagList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HtmlPageContext {
    public static final String HTML_HEAD_CSS = "html.head.css";
    public static final String HTML_HEAD_SCRIPT = "html.head.script";
    public static final String HTML_INIT_SCRIPT = "html.init_script";
    Set mIncludedResources;
    Map mContextMap;

    public static HtmlPageContext getInstance(ViewContext context) {
        HtmlPageContext page = (HtmlPageContext)context.getInstance(HtmlPageContext.class);
        if (page == null) {
            page = new HtmlPageContext(context.getMap());
            context.setInstance(HtmlPageContext.class, page);
        }
        return page;
    }

    public HtmlPageContext(Map context_map) {
        this.mContextMap = context_map;
        this.mIncludedResources = new HashSet();
    }

    public void addResource(String url) {
        this.mIncludedResources.add(url);
    }

    public boolean containsResource(String url) {
        return this.mIncludedResources.contains(url);
    }

    public TagList getNamedTagList(String name) {
        TagList list = (TagList)this.mContextMap.get(name);
        if (list == null) {
            list = new TagList();
            this.mContextMap.put(name, list);
        }
        return list;
    }

    public StringBuffer getNamedPart(String name) {
        StringBuffer buf = (StringBuffer)this.mContextMap.get(name);
        if (buf == null) {
            buf = new StringBuffer();
            this.mContextMap.put(name, buf);
        }
        return buf;
    }

    public TagList getScriptReference() {
        return this.getNamedTagList(HTML_HEAD_SCRIPT);
    }

    public void addScript(String url) {
        boolean is_added = this.containsResource(url);
        if (!is_added) {
            this.addResource(url);
            TagList list = this.getScriptReference();
            list.add(new ScriptReference(url));
        }
    }

    public TagList getCssReference() {
        return this.getNamedTagList(HTML_HEAD_CSS);
    }

    public void addStyleSheet(String url) {
        boolean is_added = this.containsResource(url);
        if (!is_added) {
            this.addResource(url);
            TagList list = this.getCssReference();
            list.add(new StyleSheetReference(url));
        }
    }

    public StringBuffer getInitScript() {
        return this.getNamedPart(HTML_INIT_SCRIPT);
    }
}

