/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util;

import java.util.HashMap;
import java.util.Map;

public class ThreadLocalUtil {
    static Map THREAD_LOCAL_MAP = new HashMap();

    public static synchronized void put(String key, Object value) {
        ThreadLocal<Object> tl = (ThreadLocal<Object>)THREAD_LOCAL_MAP.get(key);
        if (tl == null) {
            tl = new ThreadLocal<Object>();
            THREAD_LOCAL_MAP.put(key, tl);
        }
        tl.set(value);
    }

    public static synchronized void append(String key, String msg) {
        StringBuffer buf;
        ThreadLocal<StringBuffer> tl = (ThreadLocal<StringBuffer>)THREAD_LOCAL_MAP.get(key);
        if (tl == null) {
            tl = new ThreadLocal<StringBuffer>();
            THREAD_LOCAL_MAP.put(key, tl);
        }
        if ((buf = (StringBuffer)tl.get()) == null) {
            buf = new StringBuffer();
            tl.set(buf);
        }
        buf.append(msg).append("\n");
    }

    public static synchronized void appendDebugInfo(String msg) {
        ThreadLocalUtil.append("DEBUG", msg);
    }

    public static String getDebugInfo() {
        Object v = ThreadLocalUtil.get("DEBUG");
        return v == null ? null : v.toString();
    }

    public static Object get(String key) {
        ThreadLocal tl = (ThreadLocal)THREAD_LOCAL_MAP.get(key);
        if (tl == null) {
            return null;
        }
        return tl.get();
    }

    public static synchronized void remove(String key) {
        ThreadLocal tl = (ThreadLocal)THREAD_LOCAL_MAP.get(key);
        if (tl != null) {
            tl.remove();
        }
    }

    public static synchronized void removeDebugInfo() {
        ThreadLocalUtil.remove("DEBUG");
    }
}

