/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.resource;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import uncertain.core.ILifeCycle;
import uncertain.util.resource.ISourceFile;
import uncertain.util.resource.ISourceFileManager;
import uncertain.util.resource.SourceFile;

public class SourceFileManager
implements ISourceFileManager,
ILifeCycle {
    static SourceFileManager DEFAULT_INSTANCE = new SourceFileManager();
    public static final int INITIAL_SIZE = 6000;
    Map mSourceFileMap = new HashMap(6000);
    FileCheckThread mCheckThread;
    long mCheckInterval = 1000L;
    boolean isContinue = true;
    boolean isStarted = false;

    public static SourceFileManager getInstance() {
        return DEFAULT_INSTANCE;
    }

    public SourceFileManager() {
        this.startup();
    }

    @Override
    public ISourceFile getSourceFile(String resource_url) {
        File file = new File(resource_url);
        if (!file.exists()) {
            return null;
        }
        return this.getSourceFile(file);
    }

    @Override
    public ISourceFile getSourceFile(File file) {
        ISourceFile source = (ISourceFile)this.mSourceFileMap.get(file.getAbsolutePath());
        return source;
    }

    @Override
    public synchronized ISourceFile addSourceFile(File file) {
        ISourceFile source = this.getSourceFile(file);
        if (source != null) {
            return source;
        }
        source = new SourceFile(file);
        this.mSourceFileMap.put(file.getAbsolutePath(), source);
        return source;
    }

    @Override
    public boolean startup() {
        if (this.isStarted) {
            return true;
        }
        this.isContinue = true;
        this.mCheckThread = new FileCheckThread("SourceFileManager.FileCheckThread");
        if (!this.mCheckThread.isAlive()) {
            this.mCheckThread.start();
        }
        this.isStarted = true;
        return true;
    }

    @Override
    public void shutdown() {
        this.isContinue = false;
        this.mCheckThread.interrupt();
        this.isStarted = false;
    }

    public class FileCheckThread
    extends Thread {
        public FileCheckThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (SourceFileManager.this.isContinue) {
                long time = System.currentTimeMillis();
                if (SourceFileManager.this.mSourceFileMap.size() > 0) {
                    Object[] entries = null;
                    Map map = SourceFileManager.this.mSourceFileMap;
                    synchronized (map) {
                        entries = SourceFileManager.this.mSourceFileMap.values().toArray();
                    }
                    for (int i = 0; i < entries.length && SourceFileManager.this.isContinue; ++i) {
                        ISourceFile source = (ISourceFile)entries[i];
                        source.checkModified();
                    }
                }
                if (SourceFileManager.this.mCheckInterval <= (time = System.currentTimeMillis() - time)) continue;
                try {
                    FileCheckThread.sleep(SourceFileManager.this.mCheckInterval - time);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }
}

