/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bill99;

import aurora.plugin.bill99.Bill99;
import aurora.plugin.bill99.Configuration;
import aurora.plugin.bill99.HttpUtils;
import aurora.plugin.bill99.MD5Util;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class Drawback
extends AbstractEntry {
    private String merchant_id;
    private String merchant_key;
    private String version;
    private String command_type;
    private String drawbackUrl;
    private String txOrder;
    private String amount;
    private String postdate;
    private String orderid;
    private String configFile;

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest request = serviceInstance.getRequest();
        request.setCharacterEncoding("GBK");
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        this.configFile = this.getValue(context, this.getConfigFile());
        CompositeMap model = service.getModel();
        this.initConfig();
        CompositeMap bill99 = model.createChild("bill99");
        this.txOrder = this.getValue(context, this.getTxOrder());
        this.amount = this.getValue(context, this.getAmount());
        this.postdate = this.getValue(context, this.getPostdate());
        this.orderid = this.getValue(context, this.getOrderid());
        String mac = this.createSignMSG();
        HashMap<String, String> reParams = new HashMap<String, String>();
        reParams.put("mac", mac);
        reParams.put("txOrder", this.txOrder);
        reParams.put("postdate", this.postdate);
        reParams.put("amount", this.amount);
        reParams.put("orderid", this.orderid);
        reParams.put("command_type", this.command_type);
        reParams.put(Bill99.version, this.version);
        reParams.put("merchant_id", this.merchant_id);
        String xml = this.drawbackRequest(this.drawbackUrl, reParams);
        CompositeMap map = CompositeLoader.createInstanceForOCM().loadFromString(xml, "utf-8");
        List childs = map.getChilds();
        for (int i = 0; i < childs.size(); ++i) {
            CompositeMap child = (CompositeMap)childs.get(i);
            String name = child.getName().toLowerCase();
            String value = child.getText();
            bill99.put((Object)name, (Object)value);
        }
    }

    private String drawbackRequest(String drawbackUrl, Map reParams) throws IOException {
        StringBuffer buffer = new StringBuffer();
        List urlPost = HttpUtils.URLPost(drawbackUrl, reParams);
        for (int i = 0; i < urlPost.size(); ++i) {
            buffer.append(urlPost.get(i));
        }
        return buffer.toString();
    }

    private String getValue(CompositeMap context, String key) {
        if (key != null) {
            return TextParser.parse((String)key, (CompositeMap)context);
        }
        return "";
    }

    public void initConfig() {
        this.merchant_id = this.getVaule("merchant_id");
        this.merchant_key = this.getVaule("merchant_key");
        this.version = this.getVaule("drawback_version");
        this.command_type = this.getVaule("command_type");
        this.drawbackUrl = this.getVaule("drawbackUrl");
    }

    private String createSignMSG() throws UnsupportedEncodingException {
        String macstr = "";
        macstr = this.appendParam(macstr, "merchant_id", this.merchant_id);
        macstr = this.appendParam(macstr, Bill99.version, this.version);
        macstr = this.appendParam(macstr, "command_type", this.command_type);
        macstr = this.appendParam(macstr, "orderid", this.orderid);
        macstr = this.appendParam(macstr, "amount", this.amount);
        macstr = this.appendParam(macstr, "postdate", this.postdate);
        macstr = this.appendParam(macstr, "txOrder", this.txOrder);
        macstr = this.appendParam(macstr, "merchant_key", this.merchant_key);
        String mac = MD5Util.md5Hex(macstr.getBytes("utf-8")).toUpperCase();
        return mac;
    }

    public String appendParam(String returns, String paramId, String paramValue) {
        if (returns != "") {
            if (paramValue != "") {
                returns = returns + paramId + "=" + paramValue;
            }
        } else if (paramValue != "") {
            returns = paramId + "=" + paramValue;
        }
        return returns;
    }

    private String getVaule(String key) {
        String value = Configuration.getValue(this.configFile, key);
        return value == null ? "" : value;
    }

    public String getTxOrder() {
        return this.txOrder;
    }

    public void setTxOrder(String txOrder) {
        this.txOrder = txOrder;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getPostdate() {
        return this.postdate;
    }

    public void setPostdate(String postdate) {
        this.postdate = postdate;
    }

    public String getOrderid() {
        return this.orderid;
    }

    public void setOrderid(String orderid) {
        this.orderid = orderid;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

