/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.dataimport;

import aurora.database.service.SqlServiceContext;
import aurora.plugin.csv.CsvParse;
import aurora.plugin.poi.usermodel.ExcelParse;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.UncertainEngine;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ImportExcel
extends AbstractEntry {
    public static final String XLS_KEY = ".xls";
    public static final String XLSX_KEY = ".xlsx";
    public static final String CSV_KEY = ".csv";
    public static final String TXT_KEY = ".txt";
    String maxFileSize = null;
    public String fileName;
    public String separator = ",";
    public String header_id;
    public String user_id = "${/session/@user_id}";
    public String template_code;
    public String job_id;
    public String attribute1;
    public String attribute2;
    public String attribute3;
    public String attribute4;
    public String attribute5;
    public String dataSourceName;
    UncertainEngine mUncertainEngine;
    Connection conn;
    CallableStatement lineCstm = null;
    boolean is_first = true;
    int count = 0;

    public ImportExcel(UncertainEngine uncertainEngine) {
        this.mUncertainEngine = uncertainEngine;
    }

    public String getTemplate_code() {
        return this.template_code;
    }

    public void setTemplate_code(String template_code) {
        this.template_code = template_code;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        this.validatePara(context);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        SqlServiceContext sqlServiceContext = SqlServiceContext.createSqlServiceContext((CompositeMap)context);
        this.conn = sqlServiceContext.getNamedConnection(this.dataSourceName);
        if (this.conn == null) {
            sqlServiceContext.initConnection(this.mUncertainEngine.getObjectRegistry(), this.dataSourceName);
            this.conn = sqlServiceContext.getNamedConnection(this.dataSourceName);
        }
        if (this.dataSourceName == null && this.conn == null) {
            this.conn = sqlServiceContext.getConnection();
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload up = new ServletFileUpload((FileItemFactory)factory);
        long fileSizeMaxLong = 0xA00000L;
        if (this.getMaxFileSize() != null) {
            fileSizeMaxLong = Long.parseLong(this.getMaxFileSize());
        }
        up.setSizeMax(fileSizeMaxLong);
        List items = up.parseRequest(serviceInstance.getRequest());
        Iterator i = items.iterator();
        try {
            while (i.hasNext()) {
                FileItem fileItem = (FileItem)i.next();
                if (fileItem.isFormField()) continue;
                this.fileName = fileItem.getName();
                this.saveHead();
                String suffix = this.fileName.substring(this.fileName.lastIndexOf("."));
                this.parseFile(fileItem.getInputStream(), suffix.toLowerCase(), this);
            }
            System.out.println("\u5bfc\u5165\u884c\u6570:" + this.count);
            if (this.lineCstm != null) {
                this.lineCstm.executeBatch();
            }
        }
        finally {
            if (this.lineCstm != null) {
                try {
                    this.lineCstm.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveHead() throws SQLException {
        Statement cstm = null;
        String headSql = "fnd_interface_load_pkg.ins_fnd_interface_headers(?,?,?,?,?,?,?,?,?,?,?)";
        try {
            cstm = this.conn.prepareCall("{call " + headSql + "}");
            cstm.setLong(1, new Long(this.header_id));
            if (this.job_id == null) {
                cstm.setNull(2, 2);
            } else {
                cstm.setLong(2, new Long(this.job_id));
            }
            cstm.setString(3, "NEW");
            cstm.setString(4, this.user_id);
            cstm.setString(5, this.fileName);
            if (this.template_code == null) {
                cstm.setNull(6, 12);
            } else {
                cstm.setString(6, this.template_code);
            }
            if (this.attribute1 == null) {
                cstm.setNull(7, 12);
            } else {
                cstm.setString(7, this.attribute1);
            }
            if (this.attribute2 == null) {
                cstm.setNull(8, 12);
            } else {
                cstm.setString(8, this.attribute2);
            }
            if (this.attribute3 == null) {
                cstm.setNull(9, 12);
            } else {
                cstm.setString(9, this.attribute3);
            }
            if (this.attribute4 == null) {
                cstm.setNull(10, 12);
            } else {
                cstm.setString(10, this.attribute4);
            }
            if (this.attribute5 == null) {
                cstm.setNull(11, 12);
            } else {
                cstm.setString(11, this.attribute5);
            }
            cstm.execute();
        }
        finally {
            if (cstm != null) {
                cstm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseFile(InputStream is, String suffix, ImportExcel importExcel) throws Exception {
        try {
            if (XLS_KEY.equals(suffix) || XLSX_KEY.equals(suffix)) {
                ExcelParse xlsParse = new ExcelParse();
                xlsParse.parseFile(is, importExcel, suffix);
            } else if (CSV_KEY.equals(suffix) || TXT_KEY.equals(suffix)) {
                if (this.separator == null) {
                    throw new IllegalArgumentException("separator is undefined");
                }
                CsvParse cvsParser = new CsvParse();
                cvsParser.parseFile(is, importExcel);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    void validatePara(CompositeMap context) {
        this.header_id = TextParser.parse((String)this.header_id, (CompositeMap)context);
        if (this.header_id == null && "".equals(this.header_id)) {
            throw new IllegalArgumentException("header_id is undefined");
        }
        this.user_id = TextParser.parse((String)this.user_id, (CompositeMap)context);
        if (this.user_id == null && "".equals(this.user_id)) {
            throw new IllegalArgumentException("user_id is undefined");
        }
        this.template_code = TextParser.parse((String)this.template_code, (CompositeMap)context);
        this.job_id = TextParser.parse((String)this.job_id, (CompositeMap)context);
        this.attribute1 = TextParser.parse((String)this.attribute1, (CompositeMap)context);
        this.attribute2 = TextParser.parse((String)this.attribute2, (CompositeMap)context);
        this.attribute3 = TextParser.parse((String)this.attribute3, (CompositeMap)context);
        this.attribute4 = TextParser.parse((String)this.attribute4, (CompositeMap)context);
        this.attribute5 = TextParser.parse((String)this.attribute5, (CompositeMap)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLine(CompositeMap data, int rownum) throws SQLException {
        String valueString;
        boolean is_new = data.getBoolean((Object)"is_new", false);
        ++this.count;
        if (data.getLong((Object)"maxCell") == null) {
            return;
        }
        int maxcell = data.getInt((Object)"maxCell");
        boolean is_null = true;
        for (int i = 0; i < maxcell; ++i) {
            valueString = data.getString((Object)("C" + i));
            if (valueString == null || "".equals(valueString)) continue;
            is_null = false;
            break;
        }
        if (is_null) {
            return;
        }
        if (this.is_first || is_new) {
            this.is_first = false;
            StringBuffer lineSql = new StringBuffer("fnd_interface_load_pkg.ins_fnd_interface_lines(?,?,?,?,?,?,?");
            for (int i = 0; i < maxcell; ++i) {
                lineSql.append(",?");
            }
            lineSql.append(")");
            if (this.lineCstm != null) {
                try {
                    this.lineCstm.executeBatch();
                }
                finally {
                    try {
                        this.lineCstm.close();
                    }
                    catch (Exception e) {}
                    this.lineCstm = null;
                }
            }
            this.lineCstm = this.conn.prepareCall("{call " + lineSql + "}");
        }
        this.lineCstm.setLong(1, (long)new Long(this.header_id));
        this.lineCstm.setNull(2, 12);
        this.lineCstm.setNull(3, 12);
        this.lineCstm.setString(4, this.user_id);
        this.lineCstm.setLong(5, (long)rownum);
        String sheetName = data.getString((Object)"sheetName");
        if (sheetName == null) {
            this.lineCstm.setNull(6, 12);
        } else {
            this.lineCstm.setString(6, sheetName);
        }
        this.lineCstm.setNull(7, 2);
        for (int i = 0; i < maxcell; ++i) {
            valueString = data.getString((Object)("C" + i));
            if (valueString == null) {
                this.lineCstm.setNull(8 + i, 12);
                continue;
            }
            this.lineCstm.setString(8 + i, valueString);
        }
        this.lineCstm.addBatch();
        if (this.count % 1000 == 0) {
            try {
                this.is_first = true;
                this.lineCstm.executeBatch();
            }
            finally {
                if (this.lineCstm != null) {
                    try {
                        this.lineCstm.close();
                    }
                    catch (Exception e) {}
                    this.lineCstm = null;
                }
            }
        }
    }

    public String getHeader_id() {
        return this.header_id;
    }

    public void setHeader_id(String header_id) {
        this.header_id = header_id;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getUser_id() {
        return this.user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public String getJob_id() {
        return this.job_id;
    }

    public void setJob_id(String job_id) {
        this.job_id = job_id;
    }

    public String getAttribute1() {
        return this.attribute1;
    }

    public void setAttribute1(String attribute1) {
        this.attribute1 = attribute1;
    }

    public String getAttribute2() {
        return this.attribute2;
    }

    public void setAttribute2(String attribute2) {
        this.attribute2 = attribute2;
    }

    public String getAttribute3() {
        return this.attribute3;
    }

    public void setAttribute3(String attribute3) {
        this.attribute3 = attribute3;
    }

    public String getAttribute4() {
        return this.attribute4;
    }

    public void setAttribute4(String attribute4) {
        this.attribute4 = attribute4;
    }

    public String getAttribute5() {
        return this.attribute5;
    }

    public void setAttribute5(String attribute5) {
        this.attribute5 = attribute5;
    }

    public String getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public static void main(String[] args) throws Exception {
        ImportExcel importExcel = new ImportExcel(null);
        FileInputStream is = new FileInputStream("/Volumes/MacintoshHD/download/\u8d22\u52a1\u62a5\u8868\u6d4b\u8bd5_07112.xlsx");
        importExcel.parseFile(is, XLSX_KEY, importExcel);
    }
}

