/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity;

import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.plugin.entity.EntityGeneratorConfig;
import aurora.plugin.entity.model.BMModel;
import aurora.plugin.source.gen.screen.model.asm.PageGenerator;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public abstract class AbstractBMModelCreator {
    private DatabaseServiceFactory svcFactory;
    private CompositeMap context;
    protected EntityGeneratorConfig config = EntityGeneratorConfig.getInstance();

    public AbstractBMModelCreator(DatabaseServiceFactory svcFactory, CompositeMap context) {
        this.svcFactory = svcFactory;
        this.context = context;
    }

    public abstract BMModel create(CompositeMap var1) throws Exception;

    public abstract void updateBack() throws Exception;

    protected void updateEntity(CompositeMap entityMap) throws Exception {
        BusinessModelService service = this.getDatabaseServiceFactory().getModelService(this.config.entityModel, this.getContext());
        service.updateByPK((Map)entityMap);
    }

    public CompositeMap getContext() {
        return this.context;
    }

    public DatabaseServiceFactory getDatabaseServiceFactory() {
        return this.svcFactory;
    }

    protected CompositeMap getEntity(Object entityId) throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"entity_id", entityId);
        return PageGenerator.queryFirst(this.getDatabaseServiceFactory(), this.getContext(), this.config.entityModel, para);
    }

    protected String getEntityName(CompositeMap entityMap) {
        return TextParser.parse((String)this.config.getEntityNamePattern(), (CompositeMap)entityMap);
    }

    protected String getExtEntityName(CompositeMap entityMap) {
        return TextParser.parse((String)this.config.getExtEntityNamePattern(), (CompositeMap)entityMap);
    }
}

