/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity;

import aurora.application.sourcecode.SourceCodeUtil;
import aurora.database.service.DatabaseServiceFactory;
import aurora.plugin.entity.AbstractBMModelCreator;
import aurora.plugin.entity.BMModelCreator;
import aurora.plugin.entity.EntityGeneratorConfig;
import aurora.plugin.entity.ExtBMModelCreator;
import aurora.plugin.entity.gen.BaseBmGenerator;
import aurora.plugin.entity.gen.ExtendBmGenerator;
import aurora.plugin.entity.gen.SqlGenerator;
import aurora.plugin.entity.model.BMModel;
import aurora.plugin.source.gen.screen.model.asm.PageGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class EntityGenerator
extends AbstractEntry {
    private EntityGeneratorConfig config = EntityGeneratorConfig.getInstance();
    private DatabaseServiceFactory svcFactory;
    private File bmPath;
    private CompositeMap context;
    String entityId;
    String override = "false";

    public EntityGenerator(IObjectRegistry registry, DatabaseServiceFactory svcFactory) {
        this.svcFactory = svcFactory;
        File webHome = SourceCodeUtil.getWebHome((IObjectRegistry)registry);
        this.bmPath = new File(webHome, "WEB-INF/classes/" + this.config.entityPath);
    }

    public CompositeMap gen() throws Exception {
        CompositeMap entityMap = this.getEntity();
        if (entityMap != null) {
            BMModelCreator creator = new BMModelCreator(this.svcFactory, this.context);
            BMModel model = ((AbstractBMModelCreator)creator).create(entityMap);
            CompositeMap modelMap = new BaseBmGenerator(model).gen();
            this.writeBmFile(modelMap, model.getName() + ".bm");
            ((AbstractBMModelCreator)creator).updateBack();
            CompositeMap viewsMap = this.getEntityViews();
            List viewsList = viewsMap.getChildsNotNull();
            for (CompositeMap vm : viewsList) {
                ExtBMModelCreator extCreator = new ExtBMModelCreator(this.svcFactory, this.context);
                BMModel extModel = ((AbstractBMModelCreator)extCreator).create(vm);
                CompositeMap extMap = new ExtendBmGenerator(extModel).gen();
                this.writeBmFile(extMap, vm.getString((Object)"name") + ".bm");
                ((AbstractBMModelCreator)extCreator).updateBack();
            }
            String[] sqls = new SqlGenerator(model, model.getName()).gen();
            this.createTable(sqls, model.getName());
        }
        return entityMap;
    }

    private void createTable(String[] sqls, String tableName) throws Exception {
        Connection conn = this.svcFactory.getDataSource().getConnection();
        Statement stmt = conn.createStatement();
        String seq = tableName + "_s";
        try {
            stmt.executeUpdate("create sequence " + seq);
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("ORA-00955") != -1 && this.isOverride()) {
                stmt.executeUpdate("drop sequence " + seq);
                stmt.executeUpdate("create sequence " + seq);
            }
            throw e;
        }
        try {
            for (String s : sqls) {
                stmt.executeUpdate(s);
            }
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("ORA-00955") != -1 && this.isOverride()) {
                stmt.executeUpdate("drop table " + tableName);
                for (String s : sqls) {
                    stmt.executeUpdate(s);
                }
            }
            throw e;
        }
    }

    private void writeBmFile(CompositeMap data, String fileName) throws Exception {
        File f = new File(this.bmPath, fileName);
        f.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(data.toXML().getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public boolean isOverride() {
        return Boolean.parseBoolean(this.override);
    }

    public String getOverride() {
        return this.override;
    }

    public void setOverride(String override) {
        this.override = override;
    }

    private CompositeMap getEntity() throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"entity_id", (Object)this.entityId);
        return PageGenerator.queryFirst(this.svcFactory, this.context, this.config.entityModel, para);
    }

    private CompositeMap getEntityViews() throws Exception {
        CompositeMap para = new CompositeMap();
        para.put((Object)"parent_entity", (Object)this.entityId);
        para.put((Object)"type", (Object)"VIEW");
        return PageGenerator.query(this.svcFactory, this.context, this.config.entityModel, para);
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void run(ProcedureRunner runner) throws Exception {
        this.context = runner.getContext();
        this.entityId = TextParser.parse((String)this.entityId, (CompositeMap)this.context);
        this.override = TextParser.parse((String)this.override, (CompositeMap)this.context);
        CompositeMap res = this.gen();
        this.context.putObject("/parameter/@res", (Object)res);
    }
}

