/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity;

import aurora.database.service.DatabaseServiceFactory;
import aurora.plugin.entity.model.DataType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import uncertain.composite.CompositeMap;

public class OracleTableFields {
    private final String[] excluedColumns = new String[]{"CREATED_BY", "CREATION_DATE", "LAST_UPDATED_BY", "LAST_UPDATE_DATE"};
    private static String test_table_sql = "select 1 from user_objects where object_name=? and (object_type='TABLE' or object_type='VIEW')";
    private static String column_infos_sql = "select c.comments, t.column_name, t.data_type, t.data_scale  from user_tab_columns t, all_col_comments c where t.column_name = c.column_name   and t.table_name = c.table_name   and c.table_name = ?   and c.owner = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeMap getTableFields(DatabaseServiceFactory dsf, String tableName) throws Exception {
        CompositeMap fMap = new CompositeMap("fields");
        Connection conn = dsf.getDataSource().getConnection();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            tableName = tableName.toUpperCase();
            String userName = metaData.getUserName();
            if (!this.isTableExists(tableName, userName, conn)) {
                fMap.put((Object)"msg", (Object)"TABLE_NOT_EXISTS");
                CompositeMap compositeMap = fMap;
                return compositeMap;
            }
            ResultSet pkRs = metaData.getPrimaryKeys(null, userName, tableName);
            String pkName = null;
            if (pkRs.next()) {
                pkName = pkRs.getString("COLUMN_NAME");
                if (pkRs.next()) {
                    fMap.put((Object)"msg", (Object)"PK_NOT_UNIQUE");
                    CompositeMap compositeMap = fMap;
                    return compositeMap;
                }
            }
            List<String> excluedColumnList = Arrays.asList(this.excluedColumns);
            PreparedStatement ps = conn.prepareStatement(column_infos_sql);
            ps.setString(1, tableName);
            ps.setString(2, userName);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                if (excluedColumnList.contains(columnName)) continue;
                CompositeMap element = fMap.createChild("record");
                if (columnName.equalsIgnoreCase(pkName)) {
                    element.put((Object)"ispk", (Object)true);
                }
                element.put((Object)"name", (Object)columnName);
                element.put((Object)"prompt", (Object)rs.getString("COMMENTS"));
                String dbtype = rs.getString("DATA_TYPE");
                element.put((Object)"dbtype", (Object)dbtype);
                int precision = rs.getInt("DATA_SCALE");
                element.put((Object)"type", (Object)this.getDisplayType(dbtype, precision));
                element.put((Object)"javatype", (Object)this.getJavaType(dbtype, precision));
            }
            ps.close();
        }
        finally {
            conn.close();
        }
        return fMap;
    }

    private boolean isTableExists(String tableName, String userName, Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement(test_table_sql);
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        boolean res = rs.next();
        ps.close();
        return res;
    }

    private String getDisplayType(String dbType, int precision) {
        String disType = "";
        for (DataType dt : DataType.values()) {
            if (!dt.getDbType().equalsIgnoreCase(dbType)) continue;
            disType = dt.getDisplayType();
            break;
        }
        if (dbType.equals("NUMBER") && precision > 0) {
            disType = DataType.FLOAT.getDisplayType();
        }
        return disType.toUpperCase();
    }

    private String getJavaType(String dbType, int precision) {
        String javaType = "";
        for (DataType dt : DataType.values()) {
            if (!dt.getDbType().equalsIgnoreCase(dbType)) continue;
            javaType = dt.getJavaType();
            break;
        }
        if (dbType.equals("NUMBER") && precision > 0) {
            javaType = DataType.FLOAT.getJavaType();
        }
        return javaType;
    }
}

