/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity.gen;

import aurora.plugin.entity.gen.AbstractBmGenerator;
import aurora.plugin.entity.gen.DuplicateException;
import aurora.plugin.entity.model.BMModel;
import aurora.plugin.entity.model.DataType;
import aurora.plugin.entity.model.EditorType;
import aurora.plugin.entity.model.Record;
import aurora.plugin.entity.model.Relation;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;

public class BaseBmGenerator
extends AbstractBmGenerator {
    private char seqRefAlias = (char)102;
    private BMModel model;

    public BaseBmGenerator() {
    }

    public BaseBmGenerator(BMModel model) {
        this();
        this.model = model;
    }

    public BMModel getModel() {
        return this.model;
    }

    @Override
    protected String getBaseTable() {
        return this.model.getName();
    }

    private CompositeMap genFieldsMap() throws DuplicateException {
        CompositeMap fMap = this.newCompositeMap("fields");
        String pk_name = this.model.getPkRecord().getName();
        boolean haspk = false;
        for (Record r : this.model.getRecordList()) {
            if (CompositeUtil.findChild((CompositeMap)fMap, (String)"field", (String)"name", (String)r.getName()) != null) {
                throw new DuplicateException("field", "name", r.getName());
            }
            CompositeMap m = this.getNewFieldMap(r);
            if (pk_name.equals(m.getString((Object)"name"))) {
                haspk = true;
            }
            fMap.addChild(this.getNewFieldMap(r));
        }
        if (!haspk) {
            fMap.addChild(0, this.genPkFieldMap());
        }
        return fMap;
    }

    private CompositeMap genPkFieldMap() {
        CompositeMap pk = this.newCompositeMap("field");
        Record r = this.model.getPkRecord();
        pk.put((Object)"name", (Object)r.getName());
        pk.put((Object)"databaseType", (Object)"BIGINT");
        pk.put((Object)"dataType", (Object)"java.lang.Long");
        pk.put((Object)"prompt", (Object)"primary-key");
        pk.put((Object)"forUpdate", (Object)false);
        return pk;
    }

    private CompositeMap getNewFieldMap(Record r) {
        String ue;
        String ie;
        CompositeMap map = this.newCompositeMap("field");
        map.put((Object)"name", (Object)r.getName());
        DataType dt = DataType.fromString(r.getType());
        if (dt == null) {
            dt = DataType.TEXT;
        }
        map.put((Object)"databaseType", (Object)dt.getDbType());
        map.put((Object)"dataType", (Object)dt.getJavaType());
        String editor = r.getString("editor");
        map.put((Object)"defaultEditor", (Object)editor);
        map.put((Object)"prompt", (Object)r.getPrompt());
        if (!r.isForInsert()) {
            map.put((Object)"forInsert", (Object)false);
        }
        if (!r.isForUpdate()) {
            map.put((Object)"forUpdate", (Object)false);
        }
        if ((ie = r.getInsertExpression()) != null && ie.length() > 0) {
            map.put((Object)"insertExpression", (Object)ie);
        }
        if ((ue = r.getUpdateExpression()) != null && ue.length() > 0) {
            map.put((Object)"updateExpression", (Object)ue);
        }
        if (EditorType.COMBOBOX.equalsIgnoreCase(editor) || EditorType.LOV.equalsIgnoreCase(editor)) {
            String options = r.getString("options");
            if (dt.getDisplayType().equalsIgnoreCase("lookupCode")) {
                map.put((Object)"lookupCode", (Object)options);
            } else {
                map.put((Object)"options", (Object)options);
            }
        }
        return map;
    }

    private CompositeMap genPkMap() {
        CompositeMap pkMap = this.newCompositeMap("primary-key");
        CompositeMap pk = this.newCompositeMap("pk-field");
        pk.put((Object)"name", (Object)this.model.getPkRecord().getName());
        pkMap.addChild(pk);
        return pkMap;
    }

    private CompositeMap genFeatureMap() {
        CompositeMap fMap = this.newCompositeMap("features");
        CompositeMap spk = this.newCompositeMap("sequence-pk", "o");
        fMap.addChild(spk);
        return fMap;
    }

    private CompositeMap genRelationMap() throws DuplicateException {
        CompositeMap rMap = this.newCompositeMap("relations");
        for (Relation r : this.model.getRelationList()) {
            if (CompositeUtil.findChild((CompositeMap)rMap, (String)"relation", (String)"name", (String)r.getName()) == null) continue;
            throw new DuplicateException("relation", "name", r.getName());
        }
        return rMap;
    }

    private String getRefAlias(Relation r) {
        char c = this.seqRefAlias;
        this.seqRefAlias = (char)(c + '\u0001');
        return Character.toString(c);
    }

    @Override
    protected void setUpModelMap(CompositeMap map) throws DuplicateException {
        Record r = this.model.getDefaultDisplayRecord();
        if (r != null) {
            map.put((Object)"defaultDisplayField", (Object)r.getName());
        }
        map.addChild(this.genFieldsMap());
        map.addChild(this.genPkMap());
        map.addChild(this.genFeatureMap());
        map.addChild(this.genRelationMap());
        this.genQueryFieldsMap(map);
    }

    protected void genQueryFieldsMap(CompositeMap modelMap) {
        String refAlias = modelMap.getString((Object)"alias");
        refAlias = refAlias == null || refAlias.length() == 0 ? "" : refAlias + ".";
        CompositeMap qfMap = this.genQueryFieldMap(refAlias);
        if (qfMap.getChildsNotNull().size() > 0) {
            modelMap.addChild(qfMap);
        }
    }

    private CompositeMap genQueryFieldMap(String refAlias) {
        Record[] qfs;
        CompositeMap qfMap = this.newCompositeMap("query-fields");
        for (Record r : qfs = this.model.getRecords(true)) {
            if (!r.getBoolean("queryfield")) continue;
            String qt = r.getStringNotNull("query_op".toLowerCase());
            String field = r.getName();
            if (qt.equals("=") || qt.equals("like")) {
                qfMap.addChild(this.operatorQueryField(r.getName(), qt));
                continue;
            }
            if (qt.equals(">") || qt.equals("<") || qt.equals(">=") || qt.equals("<=")) {
                qfMap.addChild(this.simpleQueryField(field, field, qt, refAlias, r.getType()));
                continue;
            }
            if (qt.equals("[from,to]")) {
                qfMap.addChild(this.simpleQueryField(field, field + "_from", ">=", refAlias, r.getType()));
                qfMap.addChild(this.simpleQueryField(field, field + "_to", "<=", refAlias, r.getType()));
                continue;
            }
            if (!"%any_match%".equals(qt) && !"pre_match%".equals(qt) && !"%end_match".equals(qt)) continue;
            qfMap.addChild(this.matchQueryField(field, qt));
        }
        return qfMap;
    }

    private CompositeMap operatorQueryField(String field, String op) {
        CompositeMap q = this.newCompositeMap("query-field");
        q.put((Object)"field", (Object)field);
        q.put((Object)"queryOperator", (Object)op);
        return q;
    }

    private CompositeMap simpleQueryField(String field, String paraName, String op, String refAlias_, String type) {
        CompositeMap q = this.newCompositeMap("query-field");
        q.put((Object)"name", (Object)paraName);
        DataType dt = DataType.fromString(type);
        if (dt != null) {
            q.put((Object)"dataType", (Object)dt.getJavaType());
        }
        q.put((Object)"queryExpression", (Object)(refAlias_ + field + " " + op + " ${/parameter/@" + paraName + "}"));
        return q;
    }

    private CompositeMap matchQueryField(String field, String matchType) {
        CompositeMap map = this.newCompositeMap("query-field");
        map.put((Object)"name", (Object)field);
        String para = "${/parameter/@" + field + "}";
        String matchStr = "";
        matchStr = "pre_match%".equals(matchType) ? para + "||'%'" : ("%end_match".equals(matchType) ? "'%'||" + para : "'%'||" + para + "||'%'");
        map.put((Object)"queryExpression", (Object)(field + " like " + matchStr));
        return map;
    }
}

