/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity.model;

import aurora.plugin.entity.model.BMModel;
import aurora.plugin.entity.model.IEntityConst;
import aurora.plugin.entity.model.PkRecord;
import aurora.plugin.entity.model.Record;
import aurora.plugin.entity.model.Relation;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;

public class ModelUtil
implements IEntityConst {
    private static final String PK = "Pk-Record";
    private static final String RECORDS = Record.class.getSimpleName() + "s";
    private static final String RELATIONS = Relation.class.getSimpleName() + "s";

    public static CompositeMap toCompositeMap(BMModel model) {
        CompositeMap map = new CompositeMap(BMModel.class.getSimpleName());
        if (model == null) {
            return map;
        }
        map.put((Object)"title", (Object)model.getName());
        map.put((Object)"autoextend", (Object)model.getAutoExtends());
        map.put((Object)"defaultdisplay", (Object)model.getDefaultDisplay());
        CompositeMap pkMap = ModelUtil.toCompositeMap(model.getPkRecord());
        pkMap.setName(PK);
        map.addChild(pkMap);
        CompositeMap recordMap = new CompositeMap(RECORDS);
        for (Record r : model.getRecords()) {
            recordMap.addChild(ModelUtil.toCompositeMap(r));
        }
        map.addChild(recordMap);
        CompositeMap relationMap = new CompositeMap(RELATIONS);
        for (Relation r : model.getRelations()) {
            relationMap.addChild(ModelUtil.toCompositeMap(r));
        }
        map.addChild(relationMap);
        return map;
    }

    private static CompositeMap toCompositeMap(Record r) {
        CompositeMap map = new CompositeMap(Record.class.getSimpleName());
        if (r == null) {
            return null;
        }
        String[] keys = TABLE_COLUMN_PROPERTIES;
        ArrayList<String> keyList = new ArrayList<String>();
        for (int i = 2; i < keys.length; ++i) {
            keyList.add(keys[i]);
        }
        keyList.add("query_op");
        keyList.add("forInsert");
        keyList.add("forUpdate");
        keyList.add("forQuery");
        keyList.add("forDisplay");
        keyList.add("forLov");
        keyList.add("insertExpression");
        keyList.add("updateExpression");
        keyList.add("foreign");
        for (String k : keyList) {
            map.put((Object)k, r.get(k));
        }
        return map;
    }

    private static CompositeMap toCompositeMap(Relation r) {
        CompositeMap map = new CompositeMap(Relation.class.getSimpleName());
        if (r == null) {
            return null;
        }
        String[] keys = COLUMN_PROPERTIES;
        for (int i = 2; i < keys.length; ++i) {
            map.put((Object)keys[i], r.get(keys[i]));
        }
        map.put((Object)"ref_prompts", (Object)r.getRefPrompts());
        return map;
    }

    public static BMModel fromCompositeMap(CompositeMap map) {
        CompositeMap relMap;
        CompositeMap recMap;
        BMModel model = new BMModel();
        model.setName(map.getString((Object)"title"));
        model.setAutoExtends(map.getString((Object)"autoextend"));
        model.setDefaultDisplay(map.getString((Object)"defaultdisplay"));
        CompositeMap pkMap = map.getChild(PK);
        if (pkMap != null) {
            model.setPkRecord(ModelUtil.getRecord(pkMap));
        }
        if ((recMap = map.getChild(RECORDS)) != null) {
            List list = recMap.getChildsNotNull();
            for (CompositeMap m : list) {
                model.add(ModelUtil.getRecord(m));
            }
        }
        if ((relMap = map.getChild(RELATIONS)) != null) {
            List list = relMap.getChildsNotNull();
            for (CompositeMap m : list) {
                model.add(ModelUtil.getRelation(m));
            }
        }
        return model;
    }

    private static Record getRecord(CompositeMap map) {
        boolean ispk = PK.equals(map.getName());
        Record r = ispk ? new PkRecord() : new Record();
        String[] keys = TABLE_COLUMN_PROPERTIES;
        for (int i = 2; i < keys.length; ++i) {
            if ("queryfield".equals(keys[i])) {
                r.put(keys[i], map.getBoolean((Object)keys[i]));
            }
            r.put(keys[i], map.get((Object)keys[i]));
        }
        if (!ispk) {
            r.put("query_op", map.get((Object)"query_op"));
            r.put("forInsert", map.getBoolean((Object)"forInsert"));
            r.put("forUpdate", map.getBoolean((Object)"forUpdate"));
            r.put("forQuery", map.getBoolean((Object)"forQuery"));
            r.put("forDisplay", map.getBoolean((Object)"forDisplay"));
            r.put("forLov", map.getBoolean((Object)"forLov"));
            r.put("foreign", map.getBoolean((Object)"foreign"));
            r.put("insertExpression", map.getString((Object)"insertExpression"));
            r.put("updateExpression", map.getString((Object)"updateExpression"));
        }
        return r;
    }

    private static Relation getRelation(CompositeMap map) {
        Relation r = new Relation();
        String[] keys = COLUMN_PROPERTIES;
        for (int i = 2; i < keys.length; ++i) {
            r.put(keys[i], map.get((Object)keys[i]));
        }
        r.setRefPrompts(map.getString((Object)"ref_prompts"));
        return r;
    }

    public static String getLocalFieldName(BMModel model, String prompt) {
        for (Record r : model.getRecordList()) {
            if (!r.getPrompt().equals(prompt)) continue;
            return r.getName();
        }
        return "";
    }

    public static boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String join(List<String> list, String sep) {
        StringBuilder sb = new StringBuilder();
        if (list.size() > 0) {
            sb.append(list.get(0));
        }
        for (int i = 1; i < list.size(); ++i) {
            sb.append(sep);
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    public static String join(String[] ss, String sep) {
        StringBuilder sb = new StringBuilder();
        if (ss.length > 0) {
            sb.append(ss[0]);
        }
        for (int i = 1; i < ss.length; ++i) {
            sb.append(sep);
            sb.append(ss[i]);
        }
        return sb.toString();
    }
}

