/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.poi;

import aurora.database.IResultSetConsumer;
import aurora.database.service.SqlServiceContext;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import aurora.plugin.export.MergedHeader;
import aurora.plugin.poi.Excel2003Bean;
import aurora.plugin.poi.Excel2007Bean;
import aurora.plugin.poi.IExcelBean;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.event.IContextAcceptable;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class ExcelOutput
implements IResultSetConsumer,
IContextAcceptable {
    CellStyle headstyle;
    CellStyle bodystyle;
    Map<Integer, CellStyle> styleMap = new HashMap<Integer, CellStyle>();
    Map<Integer, CompositeMap> columnMap = new TreeMap<Integer, CompositeMap>();
    Map<Integer, Map<Integer, String>> headMap = new TreeMap<Integer, Map<Integer, String>>();
    Map<String, Object> rowMap;
    int headLevel;
    ServiceContext ServiceContext;
    ILogger mLogger;
    IObjectRegistry mObjectRegistry;
    ILocalizedMessageProvider localMsgProvider;
    IExcelBean excelBean;
    Workbook wb;
    Sheet sheet;
    CreationHelper creationHelper;
    CellStyle bodyStyle;
    String fileName;
    String fileType;
    public final String XML_ENCODING = "UTF-8";
    public static final String KEY_DATA_TYPE = "datatype";
    public static final String KEY_DATA_TYPE_NUMBER = "Number";
    public static final String KEY_DATA_TYPE_STRING = "String";
    public static final String KEY_DATA_FORMAT = "dataFormat";

    public ExcelOutput(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
        this.mLogger = LoggingContext.getLogger((String)"aurora.plugin.poi", (IObjectRegistry)this.mObjectRegistry);
    }

    void initialization() {
        IMessageProvider msgProvider = (IMessageProvider)this.mObjectRegistry.getInstanceOfType(IMessageProvider.class);
        String langString = this.ServiceContext.getSession().getString((Object)"lang", "ZHS");
        this.localMsgProvider = msgProvider.getLocalizedMessageProvider(langString);
        CompositeMap parameter = this.ServiceContext.getParameter();
        this.fileName = parameter.getString((Object)"_file_name_", "excel");
        this.fileType = parameter.getString((Object)"_format");
    }

    public void setContext(CompositeMap context) {
        this.ServiceContext = (SqlServiceContext)DynamicObject.cast((CompositeMap)context, SqlServiceContext.class);
        this.initialization();
        if ("xlsx".equals(this.fileType)) {
            this.excelBean = new Excel2007Bean();
        } else if ("xls".equals(this.fileType)) {
            this.excelBean = new Excel2003Bean();
        }
        this.wb = this.excelBean.getNewWorkbook();
        this.setCellStyle();
        this.creationHelper = this.wb.getCreationHelper();
        this.sheet = this.wb.createSheet();
        try {
            this.createExcelHeader(this.createHeaderConfig(), this.sheet, this.sheet.createRow(0), -1);
            this.sheet.createFreezePane(0, this.headLevel + 1);
        }
        catch (ServletException e) {
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    CompositeMap createHeaderConfig() throws ServletException {
        Iterator it;
        CompositeMap columnConfig = (CompositeMap)this.ServiceContext.getParameter().getObject("_column_config_/column");
        if (columnConfig == null) {
            throw new ServletException("service-output tag and output attibute must be defined");
        }
        CompositeMap contextMap = this.ServiceContext.getObjectContext();
        CompositeMap datatype = (CompositeMap)contextMap.getObject("/_export_datatype");
        if (datatype != null && (it = datatype.getChildIterator()) != null) {
            while (it.hasNext()) {
                CompositeMap record = (CompositeMap)it.next();
                String name = record.getString((Object)"field");
                CompositeMap columnRecord = columnConfig.getChildByAttrib("record", (Object)"name", (Object)name);
                columnRecord.put((Object)KEY_DATA_TYPE, (Object)record.getString((Object)KEY_DATA_TYPE.toLowerCase()));
            }
        }
        return new MergedHeader((CompositeMap)columnConfig).conifg;
    }

    int createExcelHeader(CompositeMap columnConfigs, Sheet sheet, Row header, int col) {
        int rownum = header.getRowNum();
        Iterator iterator = columnConfigs.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                CellRangeAddress range;
                Iterator it;
                ++col;
                CompositeMap record = (CompositeMap)iterator.next();
                String title = this.promptParse(record.getString((Object)"prompt"));
                Map<Integer, String> map = this.headMap.get(rownum);
                if (map != null) {
                    map.put(col, title);
                } else {
                    map = new TreeMap<Integer, String>();
                    map.put(col, title);
                    this.headMap.put(rownum, map);
                }
                int level = record.getInt((Object)"_level", 0);
                if (this.headLevel == 0) {
                    this.headLevel = level;
                }
                if ((it = record.getChildIterator()) != null) {
                    Long span = (Long)record.getObject("column/@_count");
                    range = new CellRangeAddress(rownum, rownum, col, col + span.intValue() - 1);
                    sheet.addMergedRegion(range);
                    while (it.hasNext()) {
                        Row nextRow = sheet.getRow(rownum + 1);
                        if (nextRow == null) {
                            nextRow = sheet.createRow(rownum + 1);
                        }
                        CompositeMap object = (CompositeMap)it.next();
                        col = this.createExcelHeader(object, sheet, nextRow, col - 1);
                    }
                    continue;
                }
                this.columnMap.put(col, record);
                if (level == 0) continue;
                range = new CellRangeAddress(rownum, rownum + level, col, col);
                sheet.addMergedRegion(range);
            }
        }
        return col;
    }

    String promptParse(String key) {
        String promptString = this.localMsgProvider.getMessage(key);
        promptString = promptString == null ? key : promptString;
        return promptString;
    }

    public void begin(String root_name) {
        for (Map.Entry<Integer, Map<Integer, String>> entry : this.headMap.entrySet()) {
            Map.Entry<Integer, String> colEntry;
            int col;
            Integer rowIndex = entry.getKey();
            Row row = this.sheet.createRow(rowIndex.intValue());
            Map<Integer, String> map = this.headMap.get(rowIndex);
            Iterator<Map.Entry<Integer, String>> colIterator = map.entrySet().iterator();
            while (colIterator.hasNext() && (col = Integer.valueOf((colEntry = colIterator.next()).getKey()).intValue()) + 1 <= this.excelBean.getColLimit()) {
                Cell cell = row.createCell(col);
                cell.setCellValue(this.creationHelper.createRichTextString(colEntry.getValue()));
                cell.setCellStyle(this.headstyle);
            }
        }
        this.createBodyStyle();
    }

    void createBodyStyle() {
        Map.Entry<Integer, CompositeMap> entry;
        int col;
        Iterator<Map.Entry<Integer, CompositeMap>> iterator = this.columnMap.entrySet().iterator();
        while (iterator.hasNext() && (col = Integer.valueOf((entry = iterator.next()).getKey()).intValue()) + 1 <= this.excelBean.getColLimit()) {
            CompositeMap record = entry.getValue();
            CellStyle style = this.wb.createCellStyle();
            style.cloneStyleFrom(this.bodystyle);
            style.setAlignment(this.getExcelAlign(record.getString((Object)"align")));
            this.styleMap.put(col, style);
            int width = record.getInt((Object)"width", 100);
            this.sheet.setColumnWidth(col, (int)((short)(width * 42)));
        }
    }

    public void newRow(String row_name) {
        ++this.headLevel;
        if (this.headLevel + 1 > this.excelBean.getRowLimit()) {
            String errorMsg = "The number of rows exceed the limit";
            this.mLogger.log(Level.SEVERE, errorMsg);
            throw new RuntimeException(errorMsg);
        }
        this.rowMap = new HashMap<String, Object>();
    }

    public void loadField(String name, Object value) {
        this.rowMap.put(name, value);
    }

    public void endRow() {
        Map.Entry<Integer, CompositeMap> entry;
        int col;
        Row row = this.sheet.createRow(this.headLevel);
        Iterator<Map.Entry<Integer, CompositeMap>> iterator = this.columnMap.entrySet().iterator();
        while (iterator.hasNext() && (col = Integer.valueOf((entry = iterator.next()).getKey()).intValue()) + 1 <= this.excelBean.getColLimit()) {
            this.createCell(row.createCell(col), entry.getValue());
        }
    }

    void createCell(Cell cell, CompositeMap record) {
        CellStyle style = this.styleMap.get(cell.getColumnIndex());
        cell.setCellStyle(style);
        Object value = this.rowMap.get(record.getString((Object)"name"));
        if (value != null) {
            if (record.getString((Object)KEY_DATA_TYPE) != null) {
                if (KEY_DATA_TYPE_STRING.equalsIgnoreCase(record.getString((Object)KEY_DATA_TYPE))) {
                    cell.setCellValue(this.creationHelper.createRichTextString(value.toString()));
                } else {
                    try {
                        cell.setCellValue(Double.parseDouble(value.toString()));
                    }
                    catch (Exception e) {
                        cell.setCellValue(this.creationHelper.createRichTextString(value.toString()));
                    }
                }
            } else if (value instanceof String) {
                cell.setCellValue(this.creationHelper.createRichTextString(value.toString()));
            } else if (value instanceof Number) {
                cell.setCellValue(Double.parseDouble(value.toString()));
            } else if (value != null) {
                cell.setCellValue(this.creationHelper.createRichTextString(value.toString()));
            }
        }
    }

    public void end() {
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)this.ServiceContext.getObjectContext());
        HttpServletResponse response = ((HttpServiceInstance)svc).getResponse();
        this.setResponseHeader(((HttpServiceInstance)svc).getRequest(), response);
        OutputStream out = null;
        try {
            this.ServiceContext.putBoolean("responseWrite", true);
            out = response.getOutputStream();
            this.wb.write(out);
        }
        catch (Exception e) {
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void setRecordCount(long count) {
    }

    public Object getResult() {
        return null;
    }

    void setResponseHeader(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.excelBean.getMimeType());
        response.setCharacterEncoding("UTF-8");
        response.setHeader("cache-control", "must-revalidate");
        response.setHeader("pragma", "public");
        try {
            String userAgent = request.getHeader("User-Agent");
            if (userAgent != null) {
                this.fileName = (userAgent = userAgent.toLowerCase()).indexOf("msie") != -1 ? new String(this.fileName.getBytes("GBK"), "ISO-8859-1") : new String(this.fileName.getBytes("UTF-8"), "ISO-8859-1");
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"" + this.fileName + this.excelBean.getFileExtension() + "\"");
        }
        catch (UnsupportedEncodingException e) {
            this.mLogger.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    void setCellStyle() {
        this.headstyle = this.wb.createCellStyle();
        Font headfont = this.wb.createFont();
        headfont.setFontName("\u5b8b\u4f53");
        headfont.setBoldweight((short)700);
        headfont.setFontHeightInPoints((short)12);
        this.headstyle.setFont(headfont);
        this.headstyle.setAlignment((short)2);
        this.headstyle.setVerticalAlignment((short)1);
        this.bodystyle = this.wb.createCellStyle();
        this.bodystyle.setVerticalAlignment((short)1);
        Font bodyfont = this.wb.createFont();
        bodyfont.setFontName("\u5b8b\u4f53");
        bodyfont.setFontHeightInPoints((short)12);
        this.bodystyle.setFont(bodyfont);
    }

    short getExcelAlign(String align) {
        int excelAlign = 0;
        if (align == null || "left".equalsIgnoreCase(align)) {
            excelAlign = 1;
        } else if ("right".equalsIgnoreCase(align)) {
            excelAlign = 3;
        } else if ("center".equalsIgnoreCase(align)) {
            excelAlign = 2;
        }
        return (short)excelAlign;
    }
}

