/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.AuroraIDocException;
import aurora.plugin.sap.sync.idoc.DatabaseTool;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocProcessManager;
import aurora.plugin.sap.sync.idoc.IDocServerManager;
import java.util.List;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;

public class BackupToInterfaceProcessor
implements Runnable {
    private IDocServerManager serverManager;
    private IDocProcessManager iDocProcessManager;
    private DatabaseTool dbTool;
    private ILogger logger;

    public BackupToInterfaceProcessor(IDocServerManager serverManager, IDocProcessManager iDocProcessManager) {
        this.serverManager = serverManager;
        this.iDocProcessManager = iDocProcessManager;
        this.logger = serverManager.getLogger();
    }

    @Override
    public void run() {
        while (this.serverManager.isRunning()) {
            IDocFile idocFile = this.iDocProcessManager.pollBackupFile();
            if (idocFile == null) {
                this.sleepOneSecond();
                continue;
            }
            this.backup(idocFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backup(IDocFile idocFile) {
        try {
            this.dbTool = this.serverManager.getDatabaseTool();
            String exception_message = this.backupFileData(idocFile);
            String status = exception_message == null ? "DONE" : "EXCEPTION";
            this.updateDBStatus(idocFile, status, exception_message);
            boolean successful = exception_message == null;
            this.iDocProcessManager.backupDone(idocFile, successful);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, this.getIDocFileInfo(idocFile), e);
        }
        finally {
            this.serverManager.closeDatabaseTool(this.dbTool);
        }
    }

    private void sleepOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String backupFileData(IDocFile idocFile) {
        String exception_message = null;
        try {
            this.dbTool.disableAutoCommit();
            this.insertInterface(idocFile);
            this.dbTool.commit();
            this.logger.config(this.getIDocFileInfo(idocFile) + " Backup To Interface Successful.");
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, this.getIDocFileInfo(idocFile), e);
            this.dbTool.rollback();
            exception_message = "BACKUP TO INTERFACE TABLE EXCEPTION:" + AuroraIDocException.getExceptionStackTrace(e);
        }
        finally {
            this.dbTool.enableAutoCommit();
        }
        return exception_message;
    }

    private String getIDocFileInfo(IDocFile idocFile) {
        return "idoc_file_id=" + idocFile.getIdocFileId();
    }

    private void updateDBStatus(IDocFile idocFile, String status, String exception) {
        try {
            int idocFileId = idocFile.getIdocFileId();
            this.dbTool.updateIdocFileStatus(idocFileId, status, exception);
        }
        catch (AuroraIDocException e) {
            this.logger.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void insertInterface(IDocFile idocFile) throws AuroraIDocException {
        int header_id = -1;
        int idocFileId = idocFile.getIdocFileId();
        CompositeMap iDocData = idocFile.getFileContent();
        List childList = iDocData.getChilds();
        if (childList == null) {
            return;
        }
        for (CompositeMap idoc_node : childList) {
            if (idoc_node == null || idoc_node.getChildIterator() == null || idoc_node.getChilds().size() < 2) {
                return;
            }
            CompositeMap control_node = (CompositeMap)idoc_node.getChilds().get(0);
            header_id = this.dbTool.addInterfaceHeader(idocFileId, control_node);
            for (int i = 1; i < idoc_node.getChilds().size(); ++i) {
                CompositeMap content_node = (CompositeMap)idoc_node.getChilds().get(i);
                this.dbTool.addInterfaceLine(header_id, content_node);
            }
        }
    }
}

