/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.AuroraIDocException;
import aurora.plugin.sap.sync.idoc.DatabaseTool;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocProcessManager;
import aurora.plugin.sap.sync.idoc.IDocServerManager;
import aurora.plugin.sap.sync.idoc.IDocType;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;

public class SyncProcessor
implements Runnable {
    private IDocServerManager serverManager;
    private IDocProcessManager iDocProcessManager;
    private DatabaseTool dbTool;
    private Set<IDocType> errorIdocTypes = new HashSet<IDocType>();
    private ILogger logger;

    public SyncProcessor(IDocServerManager serverManager, IDocProcessManager iDocProcessManager) {
        this.serverManager = serverManager;
        this.iDocProcessManager = iDocProcessManager;
        this.logger = serverManager.getLogger();
    }

    @Override
    public void run() {
        while (this.serverManager.isRunning()) {
            IDocFile idocFile = this.iDocProcessManager.pollSyncFile();
            if (idocFile == null) {
                this.sleepOneSecond();
                continue;
            }
            this.sync(idocFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(IDocFile idocFile) {
        try {
            this.dbTool = this.serverManager.getDatabaseTool();
            String exception_message = this.syncFileData(idocFile);
            String status = exception_message == null ? "DONE" : "EXCEPTION";
            this.updateDBStatus(idocFile, status, exception_message);
            boolean successful = exception_message == null;
            this.iDocProcessManager.syncDone(idocFile, successful);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, this.getIDocFileInfo(idocFile), (Throwable)e);
        }
        finally {
            this.serverManager.closeDatabaseTool(this.dbTool);
        }
    }

    private void sleepOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void updateDBStatus(IDocFile idocFile, String status, String exception) {
        try {
            int idocFileId = idocFile.getIdocFileId();
            this.dbTool.updateIdocFileStatus(idocFileId, status, exception);
        }
        catch (AuroraIDocException e) {
            this.logger.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String syncFileData(IDocFile idocFile) {
        String exception_message = null;
        try {
            this.dbTool.disableAutoCommit();
            this.syncMapTables(idocFile);
            this.syncTrxTables(idocFile);
            this.dbTool.commit();
            this.logger.log(this.getIDocFileInfo(idocFile) + " SYNC Successful.");
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, this.getIDocFileInfo(idocFile), e);
            this.addErrorIdocType(idocFile);
            this.dbTool.rollback();
            exception_message = "SYNC EXCEPTION:" + AuroraIDocException.getExceptionStackTrace(e);
        }
        finally {
            this.dbTool.enableAutoCommit();
        }
        return exception_message;
    }

    private void syncMapTables(IDocFile idocFile) throws Exception {
        int idoc_file_Id = idocFile.getIdocFileId();
        CompositeLoader loader = new CompositeLoader();
        CompositeMap iDocData = loader.loadByFile(idocFile.getFileFullPath());
        idocFile.setFileContent(iDocData);
        List childList = iDocData.getChilds();
        if (childList == null) {
            return;
        }
        for (CompositeMap idoc_node : childList) {
            if (idoc_node == null || idoc_node.getChilds() == null || idoc_node.getChilds().size() < 2) {
                return;
            }
            CompositeMap control_node = (CompositeMap)idoc_node.getChilds().get(0);
            IDocType idocType = this.dbTool.getIdocType(control_node);
            idocFile.setIdocType(idocType);
            if (this.isIdocTypeStop(idocFile)) {
                throw new AuroraIDocException("This idocType:" + idocType + " has error before");
            }
            this.dbTool.updateIdocFileInfo(idoc_file_Id, control_node);
            for (int i = 1; i < idoc_node.getChilds().size(); ++i) {
                CompositeMap content_node = (CompositeMap)idoc_node.getChilds().get(i);
                this.dbTool.syncMapTables(idoc_file_Id, content_node);
            }
        }
    }

    private void syncTrxTables(IDocFile idocFile) throws Exception {
        int idoc_file_Id = idocFile.getIdocFileId();
        String executePkg = this.dbTool.queryExecutePkg(idoc_file_Id);
        if (executePkg == null || "".equals(executePkg)) {
            throw new IllegalStateException(this.getIDocFileInfo(idocFile) + " please define execute_pkg first!");
        }
        String errorMessage = this.dbTool.executePkg(executePkg, idoc_file_Id);
        if (errorMessage != null && !"".equals(errorMessage)) {
            throw new AuroraIDocException(this.getIDocFileInfo(idocFile) + " execute pkg " + executePkg + " failed:" + errorMessage);
        }
    }

    private String getIDocFileInfo(IDocFile idocFile) {
        return "idoc_file_id=" + idocFile.getIdocFileId();
    }

    private boolean isIdocTypeStop(IDocFile idocFile) throws SQLException, AuroraIDocException {
        IDocType idocType = idocFile.getIdocType();
        if (idocType == null) {
            return false;
        }
        boolean isOrdinal = this.dbTool.isOrdinal(idocType.getIdoctyp(), idocType.getCimtyp());
        return isOrdinal && this.errorIdocTypes.contains(idocType);
    }

    private void addErrorIdocType(IDocFile idocFile) {
        IDocType idocType = idocFile.getIdocType();
        if (idocType != null) {
            this.errorIdocTypes.add(idocType);
        }
    }
}

