/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script.engine;

import aurora.javascript.Context;
import aurora.javascript.RhinoException;
import aurora.javascript.Script;
import aurora.plugin.script.engine.CompiledScriptCacheMBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import uncertain.core.UncertainEngine;
import uncertain.mbean.MBeanRegister;

public class CompiledScriptCache
implements CompiledScriptCacheMBean {
    private static CompiledScriptCache instance = null;
    private int maxCacheSize = 1000;
    private HashMap<Key, Value> scriptCache = new HashMap(256);

    public CompiledScriptCache(UncertainEngine engine) {
        instance = this;
        String mbean_name = engine.getMBeanName("cache", "name=script");
        MBeanRegister.resiterMBean((String)mbean_name, (Object)instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createInstanceNE(UncertainEngine engine) {
        if (instance != null) {
            return;
        }
        Class<CompiledScriptCache> clazz = CompiledScriptCache.class;
        synchronized (CompiledScriptCache.class) {
            if (instance == null) {
                new CompiledScriptCache(engine);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static CompiledScriptCache getInstance() {
        return instance;
    }

    @Override
    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script getScript(String source, Context cx, String sourceName) {
        Key k = new Key(source, cx.getOptimizationLevel());
        Value v = this.scriptCache.get(k);
        if (v == null) {
            v = new Value(cx.compileString(source, sourceName, 1, null));
            this.autoClear();
            HashMap<Key, Value> hashMap = this.scriptCache;
            synchronized (hashMap) {
                this.scriptCache.put(k, v);
            }
        } else {
            v.lastUseTime = System.currentTimeMillis();
            v.hits.incrementAndGet();
        }
        return v.script;
    }

    public Script getScript(String source, Context cx) {
        return this.getScript(source, cx, "<Unknown source>");
    }

    public boolean isChanged(File file, Context cx) {
        Key k = new Key(file, cx.getOptimizationLevel());
        Value v = this.scriptCache.get(k);
        return v == null || k.lastModif != v.lastModif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script getScript(File file, Context cx) {
        Key k = new Key(file, cx.getOptimizationLevel());
        Value v = this.scriptCache.get(k);
        if (v == null || k.lastModif != v.lastModif) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                v = new Value(cx.compileReader((Reader)br, file.getName(), 1, null), k.lastModif);
            }
            catch (RhinoException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {}
                }
            }
            this.autoClear();
            HashMap<Key, Value> hashMap = this.scriptCache;
            synchronized (hashMap) {
                this.scriptCache.put(k, v);
            }
        }
        v.lastUseTime = System.currentTimeMillis();
        v.hits.incrementAndGet();
        return v.script;
    }

    @Override
    public int getScriptSize() {
        return this.scriptCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoClear() {
        HashMap<Key, Value> hashMap = this.scriptCache;
        synchronized (hashMap) {
            if (this.scriptCache.size() >= this.maxCacheSize) {
                Set<Map.Entry<Key, Value>> set = this.scriptCache.entrySet();
                Map.Entry[] ets = set.toArray(new Map.Entry[set.size()]);
                Arrays.sort(ets, new Comparator<Map.Entry<Key, Value>>(){

                    @Override
                    public int compare(Map.Entry<Key, Value> o1, Map.Entry<Key, Value> o2) {
                        return (int)(o1.getValue().lastUseTime - o2.getValue().lastUseTime);
                    }
                });
                for (int i = 0; i < ets.length / 2; ++i) {
                    set.remove(ets[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScriptCache() {
        HashMap<Key, Value> hashMap = this.scriptCache;
        synchronized (hashMap) {
            this.scriptCache.clear();
        }
    }

    @Override
    public String getScriptDetail(int idx) {
        if (idx < 0 || idx >= this.scriptCache.size()) {
            return "Index outof bounds";
        }
        Key k = (Key)this.scriptCache.keySet().toArray()[idx];
        Value v = this.scriptCache.get(k);
        return String.format("compiled script object:%s\ncompiled at:%s\nlast use at:%s\nhits:%d\nsource detail:\n%s", v.script, new Date(v.compiledTime), new Date(v.lastUseTime), v.hits.intValue(), k.source == null ? k.file : k.source);
    }

    static class Value {
        Script script;
        long lastModif;
        long compiledTime;
        long lastUseTime;
        AtomicInteger hits = new AtomicInteger();

        Value(Script scr) {
            this.script = scr;
            this.lastUseTime = this.compiledTime = System.currentTimeMillis();
        }

        Value(Script scr, long lastModif) {
            this(scr);
            this.lastModif = lastModif;
        }
    }

    static class Key {
        String source;
        File file;
        int optLevel;
        long lastModif;

        Key(Object s, int level) {
            if (s instanceof String) {
                this.source = (String)s;
            } else if (s instanceof File) {
                this.file = (File)s;
                this.lastModif = this.file.lastModified();
            }
            this.optLevel = level;
        }

        public int hashCode() {
            if (this.file != null) {
                return this.file.hashCode() + this.optLevel;
            }
            if (this.source != null) {
                return this.source.hashCode() + this.optLevel;
            }
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key k = (Key)obj;
            return Key.eq(this.source, k.source) && Key.eq(this.file, k.file) && this.optLevel == k.optLevel;
        }

        static boolean eq(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }
    }
}

