/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.script.scriptobject;

import aurora.database.FetchDescriptor;
import aurora.database.IResultSetConsumer;
import aurora.database.rsconsumer.CompositeMapCreator;
import aurora.database.service.BusinessModelService;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.ServiceOption;
import aurora.javascript.Context;
import aurora.javascript.Function;
import aurora.javascript.NativeObject;
import aurora.javascript.Scriptable;
import aurora.javascript.ScriptableObject;
import aurora.plugin.script.scriptobject.CompositeMapObject;
import aurora.plugin.script.scriptobject.ScriptUtil;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.UncertainEngine;
import uncertain.ocm.IObjectRegistry;

public class ModelServiceObject
extends ScriptableObject {
    private static final long serialVersionUID = 8195408589085036558L;
    public static final String CLASS_NAME = "ModelService";
    private BusinessModelService service;
    private CompositeMap context;
    private DatabaseServiceFactory svcFactory;
    private FetchDescriptor desc = FetchDescriptor.fetchAll();
    private BusinessModelServiceContext serviceContext;

    public ModelServiceObject() {
    }

    public ModelServiceObject(String model) {
        this.context = ScriptUtil.getContext();
        IObjectRegistry registry = ScriptUtil.getObjectRegistry(this.context);
        if (registry != null) {
            UncertainEngine uEngine = (UncertainEngine)registry.getInstanceOfType(UncertainEngine.class);
            this.svcFactory = new DatabaseServiceFactory(uEngine);
        }
        model = TextParser.parse((String)model, (CompositeMap)this.context);
        try {
            this.service = this.svcFactory.getModelService(model, this.context);
            this.serviceContext = this.service.getServiceContext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelServiceObject jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (args.length == 0 || args[0] == Context.getUndefinedValue()) {
            return new ModelServiceObject();
        }
        if (args[0] instanceof String) {
            return new ModelServiceObject((String)args[0]);
        }
        return new ModelServiceObject();
    }

    public Object jsGet_fetchDescriptor() {
        NativeObject no = (NativeObject)ScriptUtil.newObject((Scriptable)this, "Object");
        ScriptableObject.putProperty((Scriptable)no, (String)"pagenum", (Object)this.desc.getPageNum());
        ScriptableObject.putProperty((Scriptable)no, (String)"offset", (Object)this.desc.getOffSet());
        ScriptableObject.putProperty((Scriptable)no, (String)"pagesize", (Object)this.desc.getPageSize());
        ScriptableObject.putProperty((Scriptable)no, (String)"fetchAll", (Object)this.desc.getFetchAll());
        return Context.javaToJS((Object)no, (Scriptable)this);
    }

    public void jsSet_fetchDescriptor(Object obj) {
        if (!(obj instanceof NativeObject)) {
            this.desc = FetchDescriptor.fetchAll();
            return;
        }
        FetchDescriptor fd = new FetchDescriptor();
        NativeObject no = (NativeObject)obj;
        Object o = no.get((Object)"pagenum");
        if (ScriptUtil.isValid(o)) {
            if (o instanceof String) {
                fd.setPageNum(Integer.parseInt((String)o));
            } else {
                fd.setPageNum(((Number)o).intValue());
            }
        }
        if (ScriptUtil.isValid(o = no.get((Object)"pagesize"))) {
            if (o instanceof String) {
                fd.setPageSize(Integer.parseInt((String)o));
            } else {
                fd.setPageSize(((Number)o).intValue());
            }
        }
        if (!ScriptUtil.isValid(o = no.get((Object)"fetchAll"))) {
            o = no.get((Object)"fetchall");
        }
        fd.setFetchAll("true".equalsIgnoreCase("" + o));
        this.desc = fd;
    }

    private Map convert(Object obj) {
        if (obj instanceof CompositeMapObject) {
            return ((CompositeMapObject)((Object)obj)).getData();
        }
        if (obj instanceof CompositeMap) {
            return (CompositeMap)obj;
        }
        if (obj instanceof NativeObject) {
            return (NativeObject)obj;
        }
        return new CompositeMap();
    }

    public void jsFunction_execute(Object parameter) {
        this.jsFunction_executeDml(parameter, "Execute");
    }

    public void jsFunction_insert(Object parameter) {
        this.jsFunction_executeDml(parameter, "Insert");
    }

    public void jsFunction_update(Object parameter) {
        this.jsFunction_executeDml(parameter, "Update");
    }

    public void jsFunction_delete(Object parameter) {
        this.jsFunction_executeDml(parameter, "Delete");
    }

    public CompositeMapObject jsFunction_queryAsMap(Object parameter) {
        if (!ScriptUtil.isValid(parameter)) {
            parameter = this.context.getChild("parameter");
        }
        try {
            CompositeMap data = this.service.queryAsMap(this.convert(parameter), this.desc);
            CompositeMapObject map = (CompositeMapObject)ScriptUtil.newObject((Scriptable)this, "CompositeMap");
            map.setData(data);
            CompositeMapObject compositeMapObject = map;
            return compositeMapObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsSet_option(null);
        }
    }

    public CompositeMapObject jsFunction_queryIntoMap(CompositeMapObject root, Object parameter) {
        if (!(root instanceof CompositeMapObject)) {
            throw new RuntimeException("invalid root");
        }
        if (!ScriptUtil.isValid(parameter)) {
            parameter = this.context.getChild("parameter");
        }
        try {
            this.service.queryIntoMap(this.convert(parameter), this.desc, root.getData());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsSet_option(null);
        }
        return root;
    }

    public void jsFunction_query() {
        try {
            ServiceOption so = (ServiceOption)this.context.get((Object)"__database_service_option");
            if (so != null) {
                String path = so.getString("rootPath");
                CompositeMap root = this.getMapFromRootPath(path);
                CompositeMapCreator cmc = new CompositeMapCreator(root);
                this.serviceContext.setResultsetConsumer((IResultSetConsumer)cmc);
            }
            this.service.query();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsSet_option(null);
        }
    }

    private CompositeMap getMapFromRootPath(String rootPath) {
        CompositeMap root;
        CompositeMap model = this.context.getChild("model");
        if (model == null) {
            model = this.context.createChild("model");
        }
        if ((root = (CompositeMap)model.getObject(rootPath)) == null) {
            root = model.createChildByTag(rootPath);
        }
        return root;
    }

    public void jsFunction_executeDml(Object parameter, String operation) {
        try {
            if (!ScriptUtil.isValid(parameter)) {
                parameter = this.context.getChild("parameter");
            }
            this.service.executeDml(this.convert(parameter), operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.jsSet_option(null);
        }
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public Object jsGet_option() {
        ServiceOption so = (ServiceOption)this.context.get((Object)"__database_service_option");
        if (so == null) {
            return null;
        }
        CompositeMap map = so.getObjectContext();
        NativeObject no = (NativeObject)ScriptUtil.newObject((Scriptable)this, "Object");
        for (Object o : map.keySet()) {
            if (!(o instanceof String)) continue;
            ScriptableObject.putProperty((Scriptable)no, (String)((String)o), (Object)map.get(o));
        }
        return no;
    }

    public void jsSet_option(Object obj) {
        if (!(obj instanceof NativeObject)) {
            this.context.put((Object)"__database_service_option", null);
            return;
        }
        NativeObject no = (NativeObject)obj;
        ServiceOption so = ServiceOption.createInstance();
        so.setFieldCase((byte)2);
        so.setQueryMode("freequery");
        for (Object o : no.keySet()) {
            if (!(o instanceof String)) continue;
            so.put(o, no.get(o));
            so.put((Object)o.toString().toLowerCase(), no.get(o));
        }
        this.context.put((Object)"__database_service_option", (Object)so);
    }
}

