/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen;

import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;

public class IDGenerator {
    private List<String> ids = new ArrayList<String>();
    private static final String QS = "_query_ds";
    private static final String RS = "_result_ds";

    public String genEditorID(String editorType) {
        return this.genID(editorType, 0);
    }

    public String genLinkID(String fileName) {
        if (fileName == null) {
            return null;
        }
        return this.genID(fileName + "_link", 0);
    }

    public String genDatasetID(CompositeMap dataset) {
        String[] split = dataset.getString((Object)"model", "").split("\\.");
        String name = split[split.length - 1];
        name = "resultdataset".equalsIgnoreCase(dataset.getString((Object)"component_type", "")) ? name + RS : name + QS;
        return this.genID(name, 0);
    }

    public String genID(String id, int i) {
        String oldID = id;
        if (i > 0) {
            id = id + "_" + i;
        }
        if (this.ids.contains(id)) {
            return this.genID(oldID, ++i);
        }
        this.ids.add(id);
        return id;
    }

    public String genWindowID(String linkId) {
        if (linkId == null) {
            linkId = "";
        }
        return this.genID(linkId + "_window", 0);
    }
}

