/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model.io;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.io.KEYS;
import aurora.plugin.source.gen.screen.model.properties.DefaultPropertyDescriptor;
import aurora.plugin.source.gen.screen.model.properties.IPropertyDescriptor;
import aurora.plugin.source.gen.screen.model.properties.PropertyFactory;
import java.util.List;
import uncertain.composite.CompositeMap;

public class Object2CompositeMap
implements KEYS {
    public String createXML(ScreenBody diagram) {
        CompositeMap object2xml = this.object2XML(diagram);
        return object2xml.toXML();
    }

    private CompositeMap object2XML(AuroraComponent component) {
        IPropertyDescriptor[] pds;
        CompositeMap map = this.createMap(component.getComponentType(), component);
        MapHelper helper = new MapHelper(map);
        for (IPropertyDescriptor pd : pds = this.getPropertyDescriptor(component)) {
            int style;
            if (!(pd instanceof DefaultPropertyDescriptor) || ((style = ((DefaultPropertyDescriptor)pd).getStyle()) & 0x80) == 0) continue;
            Object propertyValue = component.getPropertyValue(((DefaultPropertyDescriptor)pd).getStringId());
            if ((style & 0x1000) != 0) {
                helper.cdataNode(pd, propertyValue);
            }
            if ((style & 2) != 0) {
                helper.simple(pd, propertyValue);
            }
            if ((style & 4) != 0) {
                helper.reference(pd, propertyValue);
            }
            if ((style & 8) == 0) continue;
            helper.containment(pd, propertyValue);
        }
        return map;
    }

    private CompositeMap createMap(String name, AuroraComponent component) {
        CompositeMap compositeMap = new CompositeMap(name);
        compositeMap.put((Object)"markid", (Object)component.markid);
        compositeMap.put((Object)"class_name", (Object)component.getClass().getCanonicalName());
        return compositeMap;
    }

    private IPropertyDescriptor[] getPropertyDescriptor(AuroraComponent component) {
        PropertyFactory pf = new PropertyFactory();
        IPropertyDescriptor[] pds = pf.createPropertyDescriptors(component);
        return pds;
    }

    public CompositeMap createCompositeMap(ScreenBody viewDiagram) {
        CompositeMap object2xml = this.object2XML(viewDiagram);
        return object2xml;
    }

    public CompositeMap createCompositeMap(AuroraComponent viewDiagram) {
        CompositeMap object2xml = this.object2XML(viewDiagram);
        return object2xml;
    }

    private class MapHelper {
        CompositeMap map;

        MapHelper(CompositeMap map) {
            this.map = map;
        }

        private void simple(IPropertyDescriptor pd, Object value) {
            if (value == null || "".equals(value)) {
                return;
            }
            this.map.put((Object)("" + pd.getId()), value);
        }

        private void reference(IPropertyDescriptor pd, Object propertyValue) {
            if (pd instanceof DefaultPropertyDescriptor) {
                if ((((DefaultPropertyDescriptor)pd).getStyle() & 0x10) != 0) {
                    this.referenceList(pd, propertyValue);
                }
                if ((((DefaultPropertyDescriptor)pd).getStyle() & 0x20) != 0) {
                    this.referenceArray(pd, propertyValue);
                }
                if (propertyValue instanceof AuroraComponent) {
                    CompositeMap refMap = this.refMap(pd, (AuroraComponent)propertyValue);
                    this.map.addChild(refMap);
                }
            }
        }

        private CompositeMap refMap(IPropertyDescriptor pd, AuroraComponent propertyValue) {
            String type = propertyValue.getComponentType();
            CompositeMap refMap = Object2CompositeMap.this.createMap("reference", propertyValue);
            refMap.put((Object)"component_type", (Object)type);
            refMap.put((Object)"propertye_id", (Object)((DefaultPropertyDescriptor)pd).getStringId());
            return refMap;
        }

        private void containment(IPropertyDescriptor pd, Object propertyValue) {
            if (pd instanceof DefaultPropertyDescriptor) {
                if ((((DefaultPropertyDescriptor)pd).getStyle() & 0x10) != 0) {
                    this.containmentList(pd, propertyValue);
                }
                if ((((DefaultPropertyDescriptor)pd).getStyle() & 0x20) != 0) {
                    this.containmentArray(pd, propertyValue);
                }
                if (propertyValue instanceof AuroraComponent) {
                    CompositeMap cmap = Object2CompositeMap.this.object2XML((AuroraComponent)propertyValue);
                    cmap.put((Object)"propertye_id", (Object)((DefaultPropertyDescriptor)pd).getStringId());
                    this.map.addChild(cmap);
                }
            }
        }

        private void referenceArray(IPropertyDescriptor pd, Object propertyValue) {
            if (propertyValue instanceof AuroraComponent[]) {
                CompositeMap arrayMap = new CompositeMap("referenceArray");
                arrayMap.put((Object)"propertye_id", (Object)((DefaultPropertyDescriptor)pd).getStringId());
                AuroraComponent[] acs = (AuroraComponent[])propertyValue;
                if (acs.length == 0) {
                    return;
                }
                for (AuroraComponent auroraComponent : acs) {
                    arrayMap.addChild(this.refMap(pd, auroraComponent));
                }
                this.map.addChild(arrayMap);
            }
        }

        private void containmentArray(IPropertyDescriptor pd, Object propertyValue) {
            if (propertyValue instanceof Object[]) {
                CompositeMap arrayMap = new CompositeMap("containmentArray");
                arrayMap.put((Object)"propertye_id", (Object)((DefaultPropertyDescriptor)pd).getStringId());
                Object[] acs = (Object[])propertyValue;
                if (acs.length == 0) {
                    return;
                }
                for (Object ac : acs) {
                    if (!(ac instanceof AuroraComponent)) continue;
                    arrayMap.addChild(Object2CompositeMap.this.object2XML((AuroraComponent)ac));
                }
                this.map.addChild(arrayMap);
            }
        }

        private void referenceList(IPropertyDescriptor pd, Object propertyValue) {
            if (propertyValue instanceof List) {
                CompositeMap arrayMap = new CompositeMap("referenceList");
                arrayMap.put((Object)"propertye_id", (Object)((DefaultPropertyDescriptor)pd).getStringId());
                List acs = (List)propertyValue;
                if (acs.isEmpty()) {
                    return;
                }
                for (Object ac : acs) {
                    if (!(ac instanceof AuroraComponent)) continue;
                    arrayMap.addChild(this.refMap(pd, (AuroraComponent)ac));
                }
                this.map.addChild(arrayMap);
            }
        }

        private void containmentList(IPropertyDescriptor pd, Object propertyValue) {
            if (propertyValue instanceof List) {
                CompositeMap arrayMap = new CompositeMap("containmentList");
                arrayMap.put((Object)"propertye_id", (Object)((DefaultPropertyDescriptor)pd).getStringId());
                List acs = (List)propertyValue;
                if (acs.isEmpty()) {
                    return;
                }
                for (Object ac : acs) {
                    if (ac instanceof AuroraComponent) {
                        arrayMap.addChild(Object2CompositeMap.this.object2XML((AuroraComponent)ac));
                    }
                    if ((((DefaultPropertyDescriptor)pd).getStyle() & 0x200) != 0) {
                        arrayMap.createChild("node").setText("" + ac);
                    }
                    if ((((DefaultPropertyDescriptor)pd).getStyle() & 0x800) != 0) {
                        arrayMap.createChild("node").setText("" + ac);
                    }
                    if ((((DefaultPropertyDescriptor)pd).getStyle() & 0x400) != 0) {
                        arrayMap.createChild("node").setText("" + ac);
                    }
                    if ((((DefaultPropertyDescriptor)pd).getStyle() & 0x2000) == 0) continue;
                    arrayMap.createChild("node").setText("" + ac);
                }
                this.map.addChild(arrayMap);
            }
        }

        public void cdataNode(IPropertyDescriptor pd, Object propertyValue) {
            if (propertyValue == null || "".equals(propertyValue)) {
                return;
            }
            CompositeMap compositeMap = new CompositeMap("cdataNode");
            compositeMap.put((Object)"propertye_id", (Object)((DefaultPropertyDescriptor)pd).getStringId());
            compositeMap.setText("" + propertyValue);
            this.map.addChild(compositeMap);
        }
    }
}

