/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.service.ServiceContext;
import uncertain.composite.CompositeMap;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class JavaScriptEncode
extends AbstractEntry {
    public String key = null;

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        ServiceContext service = ServiceContext.createServiceContext(context);
        CompositeMap params = service.getParameter();
        String keyStr = this.getKey();
        if (keyStr != null) {
            String[] keys = keyStr.split(",");
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String keyValue = params.getString(key);
                if (keyValue == null) continue;
                params.put(key, this.filter(keyValue));
            }
        }
    }

    public String filter(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(value.length());
        block12: for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '<': {
                    result.append("&lt;");
                    continue block12;
                }
                case '>': {
                    result.append("&gt;");
                    continue block12;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block12;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block12;
                }
                case '%': {
                    result.append("&#37;");
                    continue block12;
                }
                case ';': {
                    result.append("&#59;");
                    continue block12;
                }
                case '(': {
                    result.append("&#40;");
                    continue block12;
                }
                case ')': {
                    result.append("&#41;");
                    continue block12;
                }
                case '&': {
                    result.append("&amp;");
                    continue block12;
                }
                case '+': {
                    result.append("&#43;");
                    continue block12;
                }
                default: {
                    result.append(value.charAt(i));
                }
            }
        }
        return result.toString();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

