/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureRegistry;
import uncertain.proc.Procedure;

public class ApplicationStartupProcedureInvoker
extends AbstractLocatableObject {
    public static final String PROCEDURE_NAME_APPLICATION_START = "application-start";
    IObjectRegistry mRegistry;
    IServiceFactory mServiceFactory;
    IProcedureRegistry mProcRegistry;
    UncertainEngine mEngine;

    public ApplicationStartupProcedureInvoker(IObjectRegistry mRegistry) {
        this.mRegistry = mRegistry;
        this.mEngine = (UncertainEngine)mRegistry.getInstanceOfType(UncertainEngine.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInitialize() throws Exception {
        Procedure app_proc;
        ILogger logger = LoggingContext.getLogger("aurora.application", this.mRegistry);
        this.mServiceFactory = (IServiceFactory)this.mRegistry.getInstanceOfType(IServiceFactory.class);
        if (this.mServiceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class);
        }
        this.mProcRegistry = (IProcedureRegistry)this.mRegistry.getInstanceOfType(IProcedureRegistry.class);
        if (this.mProcRegistry != null && (app_proc = this.mProcRegistry.getProcedure(PROCEDURE_NAME_APPLICATION_START)) != null) {
            String source = app_proc.getOriginSource() == null ? "" : app_proc.getOriginSource();
            logger.info("Running application startup procedure from " + source);
            CompositeMap context = new CompositeMap();
            String service_name = "application_init";
            try {
                ServiceInvoker.invokeProcedureWithTransaction(service_name, app_proc, this.mServiceFactory, context);
            }
            finally {
                context.clear();
            }
        }
    }
}

