/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.screen;

import aurora.application.features.screen.CompositeMapIteator;
import aurora.application.features.screen.IDataFilter;
import aurora.application.features.screen.MapFinderResult;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;
import uncertain.schema.IType;
import uncertain.schema.SimpleType;

public class ReferenceTypeFinder
extends CompositeMapIteator {
    private QualifiedName referenceType;
    private ISchemaManager sm;

    @Override
    public int process(CompositeMap map) {
        List<Attribute> match = this.getMatch(map);
        if (match != null) {
            this.getResult().add(new MapFinderResult(map, match));
        }
        return 0;
    }

    protected List<Attribute> getMatch(CompositeMap map) {
        ArrayList<Attribute> matchs = new ArrayList<Attribute>();
        boolean isMacth = false;
        Element element = this.sm.getElement(map);
        if (element != null) {
            List attrib_list = element.getAllAttributes();
            for (Attribute attrib : attrib_list) {
                IType attributeType = attrib.getAttributeType();
                boolean referenceOf = this.isReferenceType(attributeType);
                if (!referenceOf) continue;
                boolean found = true;
                IDataFilter filter = this.getFilter();
                if (filter != null) {
                    found = filter.found(map, attrib);
                }
                if (!found) continue;
                isMacth = true;
                matchs.add(attrib);
            }
            if (isMacth) {
                return matchs;
            }
        }
        return null;
    }

    protected boolean isReferenceType(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return this.referenceType.equals(((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public ReferenceTypeFinder(QualifiedName referenceType, ISchemaManager sm) {
        this.referenceType = referenceType;
        this.sm = sm;
    }
}

