/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.util;

import aurora.application.ISessionInfoProvider;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class LanguageUtil {
    public static final String DEFAULT_LANG_PATH = "/session/@lang";

    public static String getLanguagePath(IObjectRegistry reg) {
        ISessionInfoProvider sp = (ISessionInfoProvider)reg.getInstanceOfType(ISessionInfoProvider.class);
        if (sp != null) {
            return sp.getUserLanguagePath();
        }
        return DEFAULT_LANG_PATH;
    }

    public static String getSessionLanguage(IObjectRegistry reg, CompositeMap context) {
        String path = LanguageUtil.getLanguagePath(reg);
        Object obj = context.getObject(path);
        return obj == null ? null : obj.toString();
    }

    public static ILocalizedMessageProvider getLocalizedMessageProvider(IObjectRegistry reg, CompositeMap context) {
        String lang = LanguageUtil.getSessionLanguage(reg, context);
        IMessageProvider mp = (IMessageProvider)reg.getInstanceOfType(IMessageProvider.class);
        if (mp != null) {
            return mp.getLocalizedMessageProvider(lang);
        }
        return null;
    }

    public static String getTranslatedMessage(IObjectRegistry reg, String msg_text, CompositeMap context) {
        ILocalizedMessageProvider mp = LanguageUtil.getLocalizedMessageProvider(reg, context);
        return LanguageUtil.getTranslatedMessage(mp, msg_text, context);
    }

    public static String getTranslatedMessage(ILocalizedMessageProvider mp, String msg_text, CompositeMap context) {
        String s;
        if (msg_text == null) {
            return null;
        }
        if (mp != null && (s = mp.getMessage(msg_text)) != null) {
            msg_text = s;
        }
        if (msg_text.indexOf(36) >= 0) {
            msg_text = TextParser.parse(msg_text, context);
        }
        return msg_text;
    }
}

