/*
 * Decompiled with CFR 0.152.
 */
package aurora.datasource;

import aurora.datasource.DatabaseConnection;
import aurora.datasource.IDataSourceFactory;
import aurora.datasource.nativejdbc.CommonsDbcpNativeJdbcExtractor;
import aurora.datasource.nativejdbc.INativeJdbcExtractor;
import aurora.datasource.nativejdbc.WebLogicNativeJdbcExtractor;
import aurora.datasource.nativejdbc.WebSphereNativeJdbcExtractor;
import java.sql.Connection;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import uncertain.exception.BuiltinExceptionFactory;

public class JNDIDataSourceFactory
implements IDataSourceFactory {
    public static final String WEBLOGIC_CONTAINER_NAME = "WEBLOGIC";
    public static final String TOMCAT_CONTAINER_NAME = "TOMCAT";
    public static final String WAS_CONTAINER_NAME = "WAS";
    public static final String DEFAULT_CONTAINER_NAME = "WEBLOGIC";
    public static final int DEFAULT_LISTENERPORT = 7001;
    private String containerName;

    @Override
    public DataSource createDataSource(DatabaseConnection dbConfig) throws Exception {
        String jndi_name = dbConfig.getJndiName();
        if (jndi_name == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(null, "jndiName");
        }
        this.containerName = dbConfig.getContainerName();
        if (this.containerName == null) {
            this.containerName = "WEBLOGIC";
        }
        if (TOMCAT_CONTAINER_NAME.equals(this.containerName)) {
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            DataSource ds = (DataSource)envCtx.lookup(jndi_name);
            return ds;
        }
        if ("WEBLOGIC".equals(this.containerName)) {
            return this.createDataSourceInWeblogic(jndi_name, dbConfig);
        }
        throw new IllegalArgumentException("The Web Sever Container:" + this.containerName + " is not support!");
    }

    private DataSource createDataSourceInWeblogic(String jndi_name, DatabaseConnection dbConfig) throws Exception {
        Properties pros = new Properties();
        int listenerPort = dbConfig.getListenerPort() > 0 ? dbConfig.getListenerPort() : 7001;
        String provider_url = "t3://127.0.0.1:" + listenerPort;
        pros.put("java.naming.provider.url", provider_url);
        pros.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        InitialContext ctx = new InitialContext(pros);
        DataSource ds = (DataSource)ctx.lookup(jndi_name);
        return ds;
    }

    @Override
    public void cleanDataSource(DataSource ds) {
    }

    @Override
    public Connection getNativeJdbcExtractor(Connection conn) throws Exception {
        if (conn == null) {
            return null;
        }
        INativeJdbcExtractor nativeJdbcExtractor = null;
        if (this.containerName == null) {
            this.containerName = "WEBLOGIC";
        }
        if (TOMCAT_CONTAINER_NAME.equals(this.containerName)) {
            nativeJdbcExtractor = new CommonsDbcpNativeJdbcExtractor();
        } else if ("WEBLOGIC".equals(this.containerName)) {
            nativeJdbcExtractor = new WebLogicNativeJdbcExtractor();
        } else if (WAS_CONTAINER_NAME.equals(this.containerName)) {
            nativeJdbcExtractor = new WebSphereNativeJdbcExtractor();
        }
        if (nativeJdbcExtractor == null) {
            throw new IllegalArgumentException("The Web Sever Container:" + this.containerName + " is not support!");
        }
        Connection nativeConnection = nativeJdbcExtractor.getNativeConnection(conn);
        return nativeConnection;
    }
}

