/*
 * Decompiled with CFR 0.152.
 */
package aurora.datasource.nativejdbc;

import aurora.datasource.nativejdbc.INativeJdbcExtractor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;

public class CommonsDbcpNativeJdbcExtractor
implements INativeJdbcExtractor {
    private static final String GET_INNERMOST_DELEGATE_METHOD_NAME = "getInnermostDelegate";

    private Object getInnermostDelegate(Object obj) throws SQLException {
        if (obj == null) {
            return null;
        }
        try {
            Class<?> classToAnalyze = obj.getClass();
            while (!Modifier.isPublic(classToAnalyze.getModifiers())) {
                if ((classToAnalyze = classToAnalyze.getSuperclass()) != null) continue;
                return obj;
            }
            Method getInnermostDelegate = classToAnalyze.getMethod(GET_INNERMOST_DELEGATE_METHOD_NAME, null);
            Object delegate = getInnermostDelegate.invoke(obj, (Object[])null);
            return delegate != null ? delegate : obj;
        }
        catch (SecurityException ex) {
            throw new IllegalStateException("Commons DBCP getInnermostDelegate method is not accessible: " + ex);
        }
        catch (Exception ex) {
            return obj;
        }
    }

    @Override
    public Connection getNativeConnection(Connection con) throws SQLException {
        return (Connection)this.getInnermostDelegate(con);
    }
}

