/*
 * Decompiled with CFR 0.152.
 */
package aurora.datasource.nativejdbc;

import aurora.datasource.nativejdbc.INativeJdbcExtractor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

public class WebLogicNativeJdbcExtractor
implements INativeJdbcExtractor {
    private static final String JDBC_EXTENSION_NAME = "weblogic.jdbc.extensions.WLConnection";
    private final Class jdbcExtensionClass;
    private final Method getVendorConnectionMethod;

    public WebLogicNativeJdbcExtractor() {
        try {
            this.jdbcExtensionClass = this.getClass().getClassLoader().loadClass(JDBC_EXTENSION_NAME);
            this.getVendorConnectionMethod = this.jdbcExtensionClass.getMethod("getVendorConnection", null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't initialize WebLogicNativeJdbcExtractor because WebLogic API classes are not available", ex);
        }
    }

    @Override
    public Connection getNativeConnection(Connection con) throws SQLException {
        if (this.jdbcExtensionClass.isAssignableFrom(con.getClass())) {
            try {
                return (Connection)this.getVendorConnectionMethod.invoke((Object)con, (Object[])null);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not invoke WebLogic's getVendorConnection method", ex);
            }
        }
        return con;
    }
}

