/*
 * Decompiled with CFR 0.152.
 */
package aurora.i18n;

import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.i18n.DefaultLocalizedMessageProvider;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import java.util.HashMap;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.core.IGlobalInstance;

public class DatabaseBasedMessageProvider
implements IMessageProvider,
IGlobalInstance {
    private IDatabaseServiceFactory factory;
    private boolean inited = false;
    private HashMap cache = new HashMap();
    private String descModel;
    private String langPath = "";
    private String defaultLang = "";

    public DatabaseBasedMessageProvider(IDatabaseServiceFactory fact) {
        this.factory = fact;
    }

    public String getDescModel() {
        return this.descModel;
    }

    public void setDescModel(String descModel) {
        this.descModel = descModel;
    }

    @Override
    public String getLangPath() {
        return this.langPath;
    }

    public void setLangPath(String langPath) {
        this.langPath = langPath;
    }

    @Override
    public String getDefaultLang() {
        return this.defaultLang;
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public void invalid() throws Exception {
        this.inited = false;
        this.cache = new HashMap();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws Exception {
        if (!this.inited) {
            SqlServiceContext context = this.factory.createContextWithConnection();
            try {
                BusinessModelService service = this.factory.getModelService(this.getDescModel(), context.getObjectContext());
                CompositeMap resultMap = service.queryAsMap(new HashMap(), FetchDescriptor.fetchAll());
                this.cacheMessage(resultMap);
                this.inited = true;
            }
            finally {
                if (context != null) {
                    context.freeConnection();
                }
            }
        }
    }

    public void reload() throws Exception {
        this.invalid();
        this.init();
    }

    private void cacheMessage(CompositeMap map) {
        if (map != null) {
            List list = map.getChildsNotNull();
            for (CompositeMap message : list) {
                String language = message.getString("language");
                ILocalizedMessageProvider localMessageProvider = (ILocalizedMessageProvider)this.cache.get(language);
                if (localMessageProvider == null) {
                    localMessageProvider = new DefaultLocalizedMessageProvider();
                    this.cache.put(language, localMessageProvider);
                }
                String code = message.getString("prompt_code");
                String description = message.getString("description");
                localMessageProvider.putMessage(code, description);
            }
        }
    }

    public void onInitialize() throws Exception {
        this.init();
    }

    @Override
    public ILocalizedMessageProvider getLocalizedMessageProvider(String language_code) {
        return (ILocalizedMessageProvider)this.cache.get(language_code);
    }

    @Override
    public String getMessage(String language_code, String message_code) {
        ILocalizedMessageProvider localMessageProvider = (ILocalizedMessageProvider)this.cache.get(language_code);
        if (localMessageProvider == null) {
            return message_code;
        }
        return localMessageProvider.getMessage(message_code);
    }

    @Override
    public String getMessage(String language_code, String message_code, Object[] params) {
        ILocalizedMessageProvider localMessageProvider = (ILocalizedMessageProvider)this.cache.get(language_code);
        if (localMessageProvider == null) {
            return message_code;
        }
        return localMessageProvider.getMessage(message_code, params);
    }
}

