/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.api.statistics.model;

import aurora.ide.api.statistics.model.Dependency;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.api.statistics.model.Tag;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;

public class ProjectObject {
    public static final String BM = "bm";
    public static final String SCREEN = "screen";
    public static final String SVC = "svc";
    public static final String UNSUPPORT = "unsupport";
    private String projectId = "";
    private String objectId = "";
    private int fileSize = 0;
    private int scriptSize = 0;
    private List<Tag> tags = new ArrayList<Tag>();
    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private int referenced;
    private String type = "";
    private StatisticsProject project;
    private String name = "";
    private String path = "";
    private CompositeMap rootMap;

    public CompositeMap getRootMap() {
        return this.rootMap;
    }

    public void setRootMap(CompositeMap rootMap) {
        this.rootMap = rootMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public int getScriptSize() {
        return this.scriptSize;
    }

    public void setScriptSize(int scriptSize) {
        this.scriptSize = scriptSize;
    }

    public void appendScriptSize(int scriptSize) {
        this.scriptSize += scriptSize;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public void addDependency(Dependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        dependency.setProject(this.project);
        this.dependencies.add(dependency);
    }

    public void addTag(Tag tag) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        for (Tag t : this.tags) {
            boolean appendTag = t.appendTag(tag);
            if (!appendTag) continue;
            return;
        }
        tag.setObject(this);
        tag.setProject(this.project);
        this.tags.add(tag);
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public StatisticsProject getProject() {
        return this.project;
    }

    public void setProject(StatisticsProject project) {
        this.project = project;
    }

    public boolean isEquals(ProjectObject o) {
        return this.project.equals(o.getProject()) && this.path.equals(o.getPath());
    }

    public static String getType(String fileExtension) {
        if (BM.equalsIgnoreCase(fileExtension)) {
            return BM;
        }
        if (SVC.equalsIgnoreCase(fileExtension)) {
            return SVC;
        }
        if (SCREEN.equalsIgnoreCase(fileExtension)) {
            return SCREEN;
        }
        return UNSUPPORT;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public int getReferenced() {
        return this.referenced;
    }

    public void setReferenced(int referenced) {
        this.referenced = referenced;
    }
}

