/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.ScreenInclude;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import uncertain.composite.CompositeMap;
import uncertain.exception.GeneralException;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.template.ITagContent;

public class ScreenIncludeTag
implements ITagContent {
    String mScreenName;
    IObjectRegistry mReg;

    public ScreenIncludeTag(String mScreenName, IObjectRegistry mReg) {
        this.mScreenName = mScreenName;
        this.mReg = mReg;
    }

    private ScreenInclude createScreenInclude() {
        ScreenInclude inc = new ScreenInclude(this.mReg);
        return inc;
    }

    @Override
    public String getContent(CompositeMap context) {
        BuildSession session = null;
        CompositeMap root = null;
        ViewContext view_context = ViewContext.getViewContext(context);
        root = view_context != null ? view_context.getModel().getRoot() : context.getRoot();
        if (root == null) {
            throw new IllegalStateException("Can't get correct context  map containing BuildSession");
        }
        ServiceInstance svc = ServiceInstance.getInstance(root);
        ServiceContext sctx = svc.getServiceContext();
        session = (BuildSession)sctx.getInstanceOfType(BuildSession.class);
        ScreenInclude sc = this.createScreenInclude();
        CompositeMap view = ScreenInclude.createScreenIncludeConfig(this.mScreenName);
        try {
            sc.doScreenInclude(session, context, view, root);
        }
        catch (Exception ex) {
            throw new GeneralException("aurora.presentation.component.screen_include_invoke_error", new Object[]{view.toXML()}, ex);
        }
        return null;
    }
}

