/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.TreeConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class Tree
extends Component {
    public static final String VERSION = "$Revision: 7999 $";
    private static final String DEFAULT_CLASS = "item-tree";
    public static final String CONFIG_CONTEXT = "context";

    public Tree(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "tree/Tree-min.css");
        this.addJavaScript(session, context, "tree/Tree-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        TreeConfig tc = TreeConfig.getInstance(view);
        String size = "";
        String width = tc.getWidthStr();
        if (!"".endsWith(width)) {
            size = size + "width:" + width + "px;";
            this.addConfig("width", width);
        }
        String height = tc.getHeightStr();
        int h = 0;
        if (!"".endsWith(height)) {
            size = size + "height:" + height + "px;";
            this.addConfig("height", height);
            h = Integer.parseInt(height);
        }
        map.put("size", size);
        if (session.getContextPath() != null) {
            this.addConfig(CONFIG_CONTEXT, session.getContextPath() + "/");
        }
        this.addConfig("displayfield", tc.getDisplayField(model));
        if (tc.getRenderer() != null) {
            this.addConfig("renderer", tc.getRenderer());
        }
        this.addConfig("idfield", tc.getIdField(model));
        this.addConfig("parentfield", tc.getParentField(model));
        this.addConfig("showcheckbox", new Boolean(tc.isShowCheckBox()));
        this.addConfig("checkfield", tc.getCheckField());
        this.addConfig("expandfield", tc.getExpandField());
        this.addConfig("sequencefield", tc.getSequenceField(model));
        this.addConfig("iconfield", tc.getIconField());
        String searchField = tc.getSearchField(model);
        if (null != searchField && !"".equals(searchField)) {
            this.addConfig("searchfield", searchField);
            this.createSearchField(session, context);
            h -= 22;
        }
        if (h > 0) {
            map.put("bodyheight", new Integer(h));
        }
        map.put("config", this.getConfigString());
    }

    private void createSearchField(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        Integer width = (Integer)map.get("width");
        CompositeMap textField = new CompositeMap("textField");
        textField.setNameSpaceURI("http://www.aurora-framework.org/application");
        textField.put("id", map.get("id") + "_search_field");
        textField.put("width", new Integer(width - 2));
        try {
            map.put("searchField", session.buildViewAsString(model, textField));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

