/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.UploadConfig;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import aurora.service.http.UserAgentTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class Upload
extends Component {
    public static final String VERSION = "$Revision: 7994 $";
    public static final String HTML5_TEMPLATE = "upload_html5.tplt";

    public Upload(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "table/Table-min.css");
        this.addStyleSheet(session, context, "upload/upload.css");
        this.addJavaScript(session, context, "table/Table-min.js");
        this.addJavaScript(session, context, "upload/html5upload.js");
        this.addJavaScript(session, context, "upload/swfupload.js");
        this.addJavaScript(session, context, "upload/swfupload.queue.js");
        this.addJavaScript(session, context, "upload/handler.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        UploadConfig uc = UploadConfig.getInstance(view);
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(model.getRoot());
        boolean showList = uc.isShowList();
        map.put("linestyle", showList ? "block" : "none");
        if (!"default".equals(uc.getType()) && this.isSupportFileAPI(serviceInstance.getRequest())) {
            context.setTemplate(session.getTemplateByName(HTML5_TEMPLATE));
            this.processHtml5Upload(view, map, model, session);
        } else {
            this.processNormalUpload(view, map, model, session);
        }
    }

    private void processHtml5Upload(CompositeMap view, Map map, CompositeMap model, BuildSession session) throws IOException {
        UploadConfig uc = UploadConfig.getInstance(view);
        this.addUploadCard(uc, map, session, model);
        if (!uc.isShowUpload()) {
            map.put("showupload", "none");
        } else {
            HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(model.getRoot());
            String sid = "";
            if (uc.isRequireSession()) {
                sid = serviceInstance.getRequest().getSession(true).getId();
            }
            map.put("sessionId", sid);
        }
        map.put("text", session.getLocalizedPrompt(uc.getText()));
        this.addConfig("showupload", uc.isShowUpload());
        this.addConfig("sourcetype", TextParser.parse(uc.getSourceType(), model));
        this.addConfig("pkvalue", TextParser.parse(uc.getPKValue(), model));
        String context_path = model.getObject("/request/@context_path").toString();
        map.put("context_path", context_path);
        this.addConfig("filesize", new Integer(uc.getFileSize()));
        this.addConfig("totalcount", new Integer(uc.getTotalCount()));
        this.addConfig("totalfilesize", new Integer(uc.getTotalFileSize()));
        this.addConfig("filetype", uc.getFileType());
        this.addConfig("uploadurl", TextParser.parse(uc.getUploadURL(context_path + "/atm_upload.svc"), model));
        this.addConfig("deleteurl", TextParser.parse(uc.getDeleteURL(context_path + "/atm_delete.svc"), model));
        this.addConfig("downloadurl", TextParser.parse(uc.getDownloadURL(context_path + "/atm_download.svc"), model));
        map.put("config", this.getConfigString());
    }

    private void addUploadCard(UploadConfig uc, Map map, BuildSession session, CompositeMap model) {
        String uid = uc.getId() + "_ul";
        map.put("up_table", "<div id=\"" + uid + "\"> </div>");
        JSONObject config = new JSONObject();
        String context_path = model.getObject("/request/@context_path").toString();
        try {
            config.put("id", uid);
            config.put("bindtarget", uc.getId() + "_ds");
            config.put("showdelete", uc.isShowDelete());
            config.put("deleteurl", TextParser.parse(uc.getDeleteURL(context_path + "/atm_delete.svc"), model));
            config.put("downloadurl", TextParser.parse(uc.getDownloadURL(context_path + "/atm_download.svc"), model));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        map.put("upload_list", "new Aurora.UploadList(" + config.toString() + ")");
    }

    private void addUploadList(UploadConfig uc, Map map, BuildSession session, CompositeMap model) throws IOException {
        CompositeMap tb = new CompositeMap("table");
        tb.setNameSpaceURI("http://www.aurora-framework.org/application");
        tb.put("percentwidth", new Integer(100));
        tb.put("classname", "atmList");
        tb.put("showhead", new Boolean(false));
        tb.put("bindtarget", this.id + "_ds");
        tb.put("style", "border:none;background-color:#fff");
        CompositeMap tb_columns = new CompositeMap("columns");
        tb_columns.setNameSpaceURI("http://www.aurora-framework.org/application");
        tb.addChild(tb_columns);
        CompositeMap tb_column = new CompositeMap("column");
        tb_column.setNameSpaceURI("http://www.aurora-framework.org/application");
        tb_column.put("percentwidth", new Integer(100));
        tb_column.put("name", "file_name");
        if (!uc.isShowDelete()) {
            tb_column.put("renderer", "atmNotDeleteRenderer");
        } else {
            tb_column.put("renderer", "atmRenderer");
        }
        tb_columns.addChild(tb_column);
        try {
            boolean showList = uc.isShowList();
            if (showList) {
                map.put("up_table", session.buildViewAsString(model, tb));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void processNormalUpload(CompositeMap view, Map map, CompositeMap model, BuildSession session) throws IOException {
        UploadConfig uc = UploadConfig.getInstance(view);
        String id = uc.getId();
        if (!uc.isShowUpload()) {
            map.put("showupload", "none");
        } else {
            String sid = "";
            if (uc.isRequireSession()) {
                HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance(model.getRoot());
                sid = serviceInstance.getRequest().getSession(true).getId();
            }
            map.put("sessionId", sid);
        }
        if ("default".equals(uc.getType())) {
            this.addUploadList(uc, map, session, model);
        } else {
            this.addUploadCard(uc, map, session, model);
        }
        map.put("text", session.getLocalizedPrompt(uc.getText()));
        map.put("sourcetype", TextParser.parse(uc.getSourceType(), model));
        map.put("pkvalue", TextParser.parse(uc.getPKValue(), model));
        String context_path = model.getObject("/request/@context_path").toString();
        map.put("context_path", context_path);
        map.put("buttonwidth", new Integer(uc.getButtonWidth()));
        map.put("filesize", new Integer(uc.getFileSize()));
        map.put("totalcount", new Integer(uc.getTotalCount()));
        map.put("totalfilesize", new Integer(uc.getTotalFileSize()));
        map.put("filetype", uc.getFileType());
        map.put("uploadurl", TextParser.parse(uc.getUploadURL(context_path + "/atm_upload.svc"), model));
        map.put("deleteurl", TextParser.parse(uc.getDeleteURL(context_path + "/atm_delete.svc"), model));
        map.put("downloadurl", TextParser.parse(uc.getDownloadURL(context_path + "/atm_download.svc"), model));
        map.put("config", this.getConfigString());
    }

    private boolean isSupportFileAPI(HttpServletRequest request) {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("chrome", 7);
        m.put("firefox", 4);
        m.put("opera", 12);
        m.put("safari", 5);
        String agent = request.getHeader("User-Agent");
        String[] browsers = UserAgentTools.getBrowser(agent);
        String browser1 = browsers[0];
        if ("MSIE 10.0".equals(browser1)) {
            return true;
        }
        String browser = browsers[1];
        String version = browsers[2];
        for (String br : m.keySet()) {
            int bigVersion;
            if (!br.equalsIgnoreCase(browser) || (bigVersion = Integer.parseInt(version.split("\\.")[0])) < (Integer)m.get(br)) continue;
            return true;
        }
        return false;
    }
}

