/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import java.util.List;
import uncertain.composite.CompositeMap;

public class TableColumnConfig
extends ComponentConfig {
    public static final String VERSION = "$Revision: 6976 $";
    public static final String TAG_NAME = "column";
    public static final String PROPERTITY_EDITOR = "editor";
    public static final String PROPERTITY_ALIGN = "align";
    public static final String PROPERTITY_HIDDEN = "hidden";
    public static final String PROPERTITY_RENDERER = "renderer";
    public static final String PROPERTITY_FOOTER_RENDERER = "footerrenderer";
    public static final String PROPERTITY_PERCENT_WIDTH = "percentwidth";
    private static final String DEFAULT_ALIGN = "left";

    public static TableColumnConfig getInstance() {
        TableColumnConfig model = new TableColumnConfig();
        model.initialize(TableColumnConfig.createContext(null, TAG_NAME));
        model.removeMapping();
        return model;
    }

    public static TableColumnConfig getInstance(CompositeMap context) {
        TableColumnConfig model = new TableColumnConfig();
        model.initialize(TableColumnConfig.createContext(context, TAG_NAME));
        model.removeMapping();
        return model;
    }

    private void removeMapping() {
        List childs = this.object_context.getChilds();
        if (childs != null) {
            Object[] array = childs.toArray();
            for (int i = 0; i < array.length; ++i) {
                CompositeMap map = (CompositeMap)array[i];
                this.object_context.removeChild(map);
            }
        }
    }

    public boolean isHidden() {
        return this.getBoolean(PROPERTITY_HIDDEN, false);
    }

    @Override
    public void setHidden(boolean hidden) {
        this.putBoolean(PROPERTITY_HIDDEN, hidden);
    }

    public String getAlign() {
        return this.getString(PROPERTITY_ALIGN, DEFAULT_ALIGN);
    }

    public void setAlign(String align) {
        this.putString(PROPERTITY_ALIGN, align);
    }

    @Override
    public String getPrompt() {
        return this.getString("prompt");
    }

    @Override
    public void setPrompt(String prompt) {
        this.putString("prompt", prompt);
    }

    public String getPercentWidth() {
        return this.getString(PROPERTITY_PERCENT_WIDTH);
    }

    public void setPercentWidth(String percentWidth) {
        this.putString(PROPERTITY_PERCENT_WIDTH, percentWidth);
    }

    public String getFooterRenderer() {
        return this.getString(PROPERTITY_FOOTER_RENDERER);
    }

    public void setFooterRenderer(String renderer) {
        this.putString(PROPERTITY_FOOTER_RENDERER, renderer);
    }

    public String getRenderer() {
        return this.getString(PROPERTITY_RENDERER, "");
    }

    public void setRenderer(String renderer) {
        this.putString(PROPERTITY_RENDERER, renderer);
    }

    public String getEditor() {
        return this.getString(PROPERTITY_EDITOR);
    }

    public void setEditor(String editor) {
        this.putString(PROPERTITY_EDITOR, editor);
    }
}

