/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std.config;

import aurora.presentation.component.std.config.ComponentConfig;
import aurora.presentation.component.std.config.GridConfig;
import uncertain.composite.CompositeMap;

public class UploadConfig
extends ComponentConfig {
    public static final String VERSION = "$Revision: 7994 $";
    public static final String TAG_NAME = "upload";
    public static final String PROPERTITY_TYPE = "type";
    public static final String PROPERTITY_TEXT = "text";
    public static final String PROPERTITY_SOURCE_TYPE = "sourcetype";
    public static final String PROPERTITY_PK_VALUE = "pkvalue";
    public static final String PROPERTITY_TOTAL_FILE_SIZE = "totalfilesize";
    public static final String PROPERTITY_TOTAL_COUNT = "totalcount";
    public static final String PROPERTITY_FILE_SIZE = "filesize";
    public static final String PROPERTITY_FILE_TYPE = "filetype";
    public static final String PROPERTITY_BUTTON_WIDTH = "buttonwidth";
    public static final String PROPERTITY_UPLOAD_URL = "uploadurl";
    public static final String PROPERTITY_DELETE_URL = "deleteurl";
    public static final String PROPERTITY_DOWNLOAD_URL = "downloadurl";
    public static final String PROPERTITY_SHOW_DELETE = "showdelete";
    public static final String PROPERTITY_SHOW_UPLOAD = "showupload";
    public static final String PROPERTITY_SHOW_LIST = "showlist";
    public static final String PROPERTITY_SORT_SQL = "sortsql";
    public static final String PROPERTITY_REQUIRE_SESSION = "requiresession";
    public static final String DEFAULT_TYPE = "default";
    public static final String DEFAULT_SORT_SQL = "creation_date desc";

    public static UploadConfig getInstance() {
        UploadConfig model = new UploadConfig();
        model.initialize(GridConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static UploadConfig getInstance(CompositeMap context) {
        UploadConfig model = new UploadConfig();
        model.initialize(GridConfig.createContext(context, TAG_NAME));
        return model;
    }

    public String getType() {
        return this.getString(PROPERTITY_TYPE);
    }

    public void setType(String type) {
        this.putString(PROPERTITY_TYPE, type);
    }

    public String getText() {
        return this.getString(PROPERTITY_TEXT, TAG_NAME);
    }

    public void setText(String text) {
        this.putString(PROPERTITY_TEXT, text);
    }

    public String getSourceType() {
        return this.getString(PROPERTITY_SOURCE_TYPE, PROPERTITY_SOURCE_TYPE);
    }

    public void setSourceType(String sourceType) {
        this.putString(PROPERTITY_SOURCE_TYPE, sourceType);
    }

    public String getPKValue() {
        return this.getString(PROPERTITY_PK_VALUE, PROPERTITY_PK_VALUE);
    }

    public void setPKValue(String pkValue) {
        this.putString(PROPERTITY_PK_VALUE, pkValue);
    }

    public String getFileType() {
        return this.getString(PROPERTITY_FILE_TYPE, "*.*");
    }

    public void setFileType(String fileType) {
        this.putString(PROPERTITY_FILE_TYPE, fileType);
    }

    public String getUploadURL() {
        return this.getString(PROPERTITY_UPLOAD_URL);
    }

    public void setSortSql(String sql) {
        this.putString(PROPERTITY_SORT_SQL, sql);
    }

    public String getSortSql() {
        return this.getString(PROPERTITY_SORT_SQL, DEFAULT_SORT_SQL);
    }

    public String getUploadURL(String defaultValue) {
        return this.getString(PROPERTITY_UPLOAD_URL, defaultValue);
    }

    public String getDeleteURL() {
        return this.getString(PROPERTITY_DELETE_URL);
    }

    public String getDeleteURL(String defaultValue) {
        return this.getString(PROPERTITY_DELETE_URL, defaultValue);
    }

    public void setDeleteURL(String deleteURL) {
        this.putString(PROPERTITY_DELETE_URL, deleteURL);
    }

    public String getDownloadURL() {
        return this.getString(PROPERTITY_DOWNLOAD_URL);
    }

    public String getDownloadURL(String defaultValue) {
        return this.getString(PROPERTITY_DOWNLOAD_URL, defaultValue);
    }

    public void setDownloadURL(String downloadURL) {
        this.putString(PROPERTITY_DOWNLOAD_URL, downloadURL);
    }

    public boolean isShowUpload() {
        return this.getBoolean(PROPERTITY_SHOW_UPLOAD, true);
    }

    public void setShowUpload(boolean showUpload) {
        this.putBoolean(PROPERTITY_SHOW_UPLOAD, showUpload);
    }

    public boolean isShowDelete() {
        return this.getBoolean(PROPERTITY_SHOW_DELETE, true);
    }

    public void setShowDelete(boolean showDelete) {
        this.putBoolean(PROPERTITY_SHOW_DELETE, showDelete);
    }

    public boolean isRequireSession() {
        return this.getBoolean(PROPERTITY_REQUIRE_SESSION, true);
    }

    public void setRequireSession(boolean requireSession) {
        this.putBoolean(PROPERTITY_REQUIRE_SESSION, requireSession);
    }

    public boolean isShowList() {
        return this.getBoolean(PROPERTITY_SHOW_LIST, true);
    }

    public void setShowList(boolean showList) {
        this.putBoolean(PROPERTITY_SHOW_LIST, showList);
    }

    public int getButtonWidth() {
        return this.getInt(PROPERTITY_BUTTON_WIDTH, 50);
    }

    public void setButtonWidth(int buttonWidth) {
        this.putInt(PROPERTITY_BUTTON_WIDTH, buttonWidth);
    }

    public int getFileSize() {
        return this.getInt(PROPERTITY_FILE_SIZE, 0);
    }

    public void setFileSize(int fileSize) {
        this.putInt(PROPERTITY_FILE_SIZE, fileSize);
    }

    public int getTotalFileSize() {
        return this.getInt(PROPERTITY_TOTAL_FILE_SIZE, 0);
    }

    public void setTotalFileSize(int tfs) {
        this.putInt(PROPERTITY_TOTAL_FILE_SIZE, tfs);
    }

    public int getTotalCount() {
        return this.getInt(PROPERTITY_TOTAL_COUNT, 0);
    }

    public void setTotalCount(int count) {
        this.putInt(PROPERTITY_TOTAL_COUNT, count);
    }
}

