/*
 * Decompiled with CFR 0.152.
 */
package aurora.security.crypto.keygen;

import aurora.security.crypto.keygen.BytesKeyGenerator;
import aurora.security.crypto.keygen.HexEncodingStringKeyGenerator;
import aurora.security.crypto.keygen.SecureRandomBytesKeyGenerator;
import aurora.security.crypto.keygen.SharedKeyGenerator;
import aurora.security.crypto.keygen.StringKeyGenerator;

public class KeyGenerators {
    public static BytesKeyGenerator secureRandom() {
        return new SecureRandomBytesKeyGenerator();
    }

    public static BytesKeyGenerator secureRandom(int keyLength) {
        return new SecureRandomBytesKeyGenerator(keyLength);
    }

    public static BytesKeyGenerator shared(int keyLength) {
        return new SharedKeyGenerator(KeyGenerators.secureRandom(keyLength).generateKey());
    }

    public static StringKeyGenerator string() {
        return new HexEncodingStringKeyGenerator(KeyGenerators.secureRandom());
    }
}

