/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.ws;

import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.ServiceOutputConfig;
import aurora.service.http.HttpServiceInstance;
import aurora.service.ws.ISOAPConfiguration;
import com.sun.xml.internal.messaging.saaj.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.composite.TextParser;
import uncertain.composite.XMLOutputter;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.ProcedureRunner;
import uncertain.util.LoggingUtil;

public class SOAPServiceInterpreter {
    public static final String DEFAULT_SOAP_CONTENT_TYPE = "text/xml;charset=utf-8";
    public static final String HEAD_SOAP_PARAMETER = "soapaction";
    public static final QualifiedName ENVELOPE = new QualifiedName("soapenv", "http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
    public static final QualifiedName HEADER = new QualifiedName("soapenv", "http://schemas.xmlsoap.org/soap/envelope/", "Header");
    public static final QualifiedName BODY = new QualifiedName("soapenv", "http://schemas.xmlsoap.org/soap/envelope/", "Body");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private IObjectRegistry mRegistry;

    public SOAPServiceInterpreter(IObjectRegistry registry) {
        this.mRegistry = registry;
    }

    public int preParseParameter(ServiceContext service_context) throws Exception {
        if (!this.isSOAPRequest(service_context)) {
            return 0;
        }
        service_context.setRequestType(HEAD_SOAP_PARAMETER);
        CompositeMap context = service_context.getObjectContext();
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(context);
        HttpServletRequest request = svc.getRequest();
        String soapActionParam = this.getSOAPAction(request);
        context.putObject("/request/@soapaction", (Object)soapActionParam, true);
        String soapContent = this.inputStream2String((InputStream)svc.getRequest().getInputStream());
        ILogger logger = LoggingContext.getLogger(context, this.getClass().getCanonicalName());
        logger.config("request:" + LINE_SEPARATOR + soapContent);
        if (soapContent == null || "".equals(soapContent)) {
            return 0;
        }
        CompositeLoader cl = new CompositeLoader();
        CompositeMap soap = cl.loadFromString(soapContent, "UTF-8");
        if (this.isHasHeaderMessage(soap)) {
            service_context.setParameter(soap);
        } else {
            CompositeMap parameter = (CompositeMap)soap.getChild(BODY.getLocalName()).getChilds().get(0);
            service_context.setParameter(parameter);
        }
        this.parseAuthorization(service_context);
        logger.config("context:" + LINE_SEPARATOR + service_context.getObjectContext().toXML());
        return 0;
    }

    private boolean isHasHeaderMessage(CompositeMap soap) {
        CompositeMap header = soap.getChild(HEADER.getLocalName());
        if (header == null) {
            return false;
        }
        return !header.isEmpty() || header.getChilds() != null;
    }

    private void parseAuthorization(ServiceContext service_context) {
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(service_context.getObjectContext());
        String authorization = svc.getRequest().getHeader("Authorization");
        if (authorization != null) {
            String encodeAuth = authorization.substring("Basic ".length());
            String decode = Base64.base64Decode((String)encodeAuth);
            String[] strs = decode.split(":");
            CompositeMap record = new CompositeMap("Authorization");
            record.put("user", strs[0]);
            record.put("password", strs[1]);
            service_context.getObjectContext().addChild(record);
        }
    }

    public String inputStream2String(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = -1;
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        String result = new String(baos.toByteArray(), "UTF-8");
        return result;
    }

    void prepareResponse(HttpServletResponse response) {
        response.setContentType(DEFAULT_SOAP_CONTENT_TYPE);
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setHeader("Server", "Simple-Server/1.1");
        response.setHeader("Transfer-Encoding", "chunked");
        response.setCharacterEncoding("UTF-8");
    }

    public void writeResponse(ServiceContext service_context) throws Exception {
        CompositeMap context = service_context.getObjectContext();
        ILogger logger = LoggingContext.getLogger(context, this.getClass().getCanonicalName());
        logger.config("context:" + context.toXML());
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(context);
        HttpServletRequest request = svc.getRequest();
        if (!this.isSOAPRequest(request)) {
            return;
        }
        String status = service_context.isSuccess() ? "Y" : "N";
        context.put("status", status);
        context.put("message", "successful");
        String soapFullControl = context.getString("soapResponseFullControl", "N");
        if ("Y".equalsIgnoreCase(soapFullControl)) {
            CompositeMap result = this.getServiceOutput(service_context, svc, logger);
            this.writeResponse(svc.getResponse(), logger, result);
            return;
        }
        boolean isBMRequest = this.isBMRequest(request);
        ISOAPConfiguration soapConfiguration = (ISOAPConfiguration)this.mRegistry.getInstanceOfType(ISOAPConfiguration.class);
        if (soapConfiguration == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, ISOAPConfiguration.class, this.getClass().getName());
        }
        CompositeMap dbConfig = this.queryDBConfig(soapConfiguration, request);
        CompositeMap body = this.createSOAPBody();
        if (dbConfig != null && dbConfig.getChilds() != null) {
            CompositeMap record = (CompositeMap)dbConfig.getChilds().get(0);
            String response_xml = TextParser.parse(record.getString("response_xml"), context);
            CompositeMap response_content = new CompositeLoader().loadFromString(response_xml, "UTF-8");
            body.addChild(response_content);
        } else {
            String multi = request.getParameter("multi");
            if (isBMRequest && !"Y".equalsIgnoreCase(multi)) {
                CompositeMap autoResponse = soapConfiguration.getDefaultResponse();
                String response_xml = TextParser.parse(XMLOutputter.defaultInstance().toXML(autoResponse), context);
                CompositeMap response_content = new CompositeLoader().loadFromString(response_xml, "UTF-8");
                body.addChild(response_content);
            } else {
                CompositeMap result = this.getServiceOutput(service_context, svc, logger);
                result.put("success", (Object)service_context.isSuccess());
                body.addChild(result);
            }
        }
        this.writeResponse(svc.getResponse(), logger, body.getRoot());
    }

    private void writeResponse(HttpServletResponse response, ILogger logger, CompositeMap soapResponse) throws IOException {
        this.prepareResponse(response);
        PrintWriter out = response.getWriter();
        out.append("<?xml version='1.0' encoding='UTF-8'?>").append(LINE_SEPARATOR);
        String content = XMLOutputter.defaultInstance().toXML(soapResponse);
        logger.config("response content:" + LINE_SEPARATOR + content);
        out.print(content);
        out.flush();
    }

    public void onCreateSuccessResponse(ServiceContext service_context) throws Exception {
        if (this.isSOAPRequest(service_context)) {
            this.writeResponse(service_context);
        }
    }

    public void onCreateFailResponse(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        ServiceContext service_context = ServiceContext.createServiceContext(context);
        if (!this.isSOAPRequest(service_context)) {
            return;
        }
        service_context.setRequestType(HEAD_SOAP_PARAMETER);
        ILogger logger = LoggingContext.getLogger(context, "aurora.application");
        Throwable thr = runner.getException();
        if (thr != null) {
            LoggingUtil.logException(thr, logger);
        }
        String status = service_context.isSuccess() ? "Y" : "N";
        String message = (String)context.getObject("/error/@message");
        if (message == null) {
            message = "fail";
        }
        context.put("status", status);
        context.put("message", message);
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(context);
        HttpServletResponse response = svc.getResponse();
        this.prepareResponse(response);
        PrintWriter out = response.getWriter();
        out.append("<?xml version='1.0' encoding='UTF-8'?>");
        CompositeMap body = this.createSOAPBody();
        CompositeMap soap_error = service_context.getObjectContext().getChild("result");
        if (soap_error != null) {
            body.addChild(soap_error);
        } else {
            ISOAPConfiguration soapConfiguration = (ISOAPConfiguration)this.mRegistry.getInstanceOfType(ISOAPConfiguration.class);
            if (soapConfiguration == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException(null, ISOAPConfiguration.class, this.getClass().getName());
            }
            CompositeMap dbConfig = this.queryDBConfig(soapConfiguration, svc.getRequest());
            if (dbConfig != null && dbConfig.getChilds() != null) {
                CompositeMap record = (CompositeMap)dbConfig.getChilds().get(0);
                String response_xml = TextParser.parse(record.getString("response_xml"), context);
                CompositeMap response_content = new CompositeLoader().loadFromString(response_xml, "UTF-8");
                body.addChild(response_content);
            } else {
                CompositeMap defaultResponse = soapConfiguration.getDefaultResponse();
                String response_xml = TextParser.parse(XMLOutputter.defaultInstance().toXML(defaultResponse), context);
                CompositeMap response_content = new CompositeLoader().loadFromString(response_xml, "UTF-8");
                body.addChild(response_content);
            }
        }
        out.println(body.getRoot().toXML());
        out.flush();
    }

    private boolean isBMRequest(HttpServletRequest request) {
        return "/autocrud".equalsIgnoreCase(request.getServletPath());
    }

    private CompositeMap queryDBConfig(ISOAPConfiguration soapConfiguration, HttpServletRequest request) throws Exception {
        String model = soapConfiguration.getModel();
        if (model == null) {
            return null;
        }
        String url = request.getRequestURL().toString();
        CompositeMap parameter = new CompositeMap("parameter");
        parameter.put("url", url);
        parameter.put("response_format_fixed", "Y");
        parameter.put("enabled_flag", "Y");
        return this.queryBM(model, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeMap queryBM(String bm_name, CompositeMap parameter) throws Exception {
        IDatabaseServiceFactory databaseServiceFactory = (IDatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (databaseServiceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IDatabaseServiceFactory.class, this.getClass().getName());
        }
        SqlServiceContext sqlContext = databaseServiceFactory.createContextWithConnection();
        try {
            CompositeMap resultMap;
            CompositeMap context = sqlContext.getObjectContext();
            if (context == null) {
                context = new CompositeMap();
            }
            BusinessModelService service = databaseServiceFactory.getModelService(bm_name, context);
            CompositeMap compositeMap = resultMap = service.queryAsMap(parameter, FetchDescriptor.fetchAll());
            return compositeMap;
        }
        finally {
            if (sqlContext != null) {
                sqlContext.freeConnection();
            }
        }
    }

    private boolean isSOAPRequest(ServiceContext service_context) {
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(service_context.getObjectContext());
        return this.isSOAPRequest(svc.getRequest());
    }

    private String getSOAPAction(HttpServletRequest svc) {
        String soapParam = svc.getHeader(HEAD_SOAP_PARAMETER);
        if (soapParam != null) {
            return soapParam;
        }
        soapParam = svc.getParameter(HEAD_SOAP_PARAMETER);
        if (soapParam != null) {
            return soapParam;
        }
        return null;
    }

    private boolean isSOAPRequest(HttpServletRequest svc) {
        String soapParam = this.getSOAPAction(svc);
        return soapParam != null;
    }

    private CompositeMap createSOAPBody() {
        CompositeMap env = new CompositeMap(ENVELOPE.getPrefix(), ENVELOPE.getNameSpace(), ENVELOPE.getLocalName());
        CompositeMap body = new CompositeMap(BODY.getPrefix(), BODY.getNameSpace(), BODY.getLocalName());
        env.addChild(body);
        return body;
    }

    private CompositeMap getServiceOutput(ServiceContext service_context, HttpServiceInstance svc, ILogger logger) {
        String output = null;
        ServiceOutputConfig cfg = svc.getServiceOutputConfig();
        if (cfg != null) {
            output = cfg.getOutput();
        }
        logger.config("ServiceOutputPath:" + output);
        CompositeMap result = null;
        boolean write_result = service_context.getBoolean("write_result", true);
        if (write_result) {
            if (output != null) {
                Object obj = service_context.getObjectContext().getObject(output);
                if (obj != null) {
                    if (!(obj instanceof CompositeMap)) {
                        throw new IllegalArgumentException("Target for SOAP output is not instance of CompositeMap: " + obj);
                    }
                    result = (CompositeMap)obj;
                } else {
                    result = new CompositeMap("result");
                }
            } else {
                result = service_context.getModel();
            }
            if (result.getNamespaceURI() == null) {
                result.setNameSpaceURI("http://www.aurora-framework.org/schema");
            }
        }
        return result;
    }
}

